/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.hbase;

import brickhouse.hbase.HTableFactory;
import java.util.Map;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;

@Description(name="hbase_get", value="_FUNC_(table,key,family) - Do a single HBase Get on a table ")
public class GetUDF
extends UDF {
    public String evaluate(Map<String, String> config, String key) {
        try {
            HTable table = HTableFactory.getHTable(config);
            Get theGet = new Get(key.getBytes());
            Result res = table.get(theGet);
            byte[] valBytes = res.getValue(config.get(HTableFactory.FAMILY_TAG).getBytes(), config.get(HTableFactory.QUALIFIER_TAG).getBytes());
            if (valBytes != null) {
                return new String(valBytes);
            }
            return null;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }
}

