/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.hbase;

import brickhouse.hbase.HTableFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

public class HbaseScanUDTF
extends GenericUDTF {
    private Map<String, String> config;
    private String[] columns;

    public void close() throws HiveException {
        try {
            this.getTable().close();
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public StructObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        ObjectInspector configInspector = arg0[0];
        this.config = HTableFactory.getConfigFromConstMapInspector(configInspector);
        String[] columns = this.config.get(HTableFactory.FAMILY_TAG).split(",");
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("key");
        columnList.addAll(Arrays.asList(columns));
        ArrayList<JavaStringObjectInspector> colInspectors = new ArrayList<JavaStringObjectInspector>();
        for (int i = 0; i < columnList.size(); ++i) {
            colInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        StandardStructObjectInspector sInspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnList, colInspectors);
        return sInspector;
    }

    public void process(Object[] arg0) throws HiveException {
        try {
            Scan sc = new Scan();
            for (String col : this.getColumns()) {
                sc.addColumn(col.getBytes(), this.getQualifier().getBytes());
            }
            ResultScanner rs = this.getTable().getScanner(sc);
            for (Result result : rs) {
                List columns = this.getColumns(result);
                this.forward(columns);
            }
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public String[] getColumns() {
        String[] columns = this.config.get(HTableFactory.FAMILY_TAG).split(",");
        return columns;
    }

    public String getQualifier() {
        String qualifier = this.config.get(HTableFactory.QUALIFIER_TAG);
        return qualifier;
    }

    public List getColumns(Result res) {
        ArrayList<String> colList = new ArrayList<String>();
        String[] columns = this.config.get(HTableFactory.FAMILY_TAG).split(",");
        String qualifier = this.config.get(HTableFactory.QUALIFIER_TAG);
        for (int i = 0; i < columns.length; ++i) {
            String col = columns[i];
            KeyValue cl = res.getColumnLatest(col.getBytes(), qualifier.getBytes());
            if (i == 0) {
                colList.add(new String(cl.getKey()));
            }
            colList.add(new String(cl.getFamily()));
        }
        return colList;
    }

    public HTable getTable() throws IOException {
        return HTableFactory.getHTable(this.config);
    }
}

