/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.hbase;

import brickhouse.hbase.HTableFactory;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.log4j.Logger;

@Description(name="hbase_put", value="string _FUNC_(config, map<string, string> key_value) - \nstring _FUNC_(config, key, value) - Do a HBase Put on a table.  Config must contain zookeeper \nquorum, table name, column, and qualifier. Example of usage: \n  hbase_put(map('hbase.zookeeper.quorum', 'hb-zoo1,hb-zoo2', \n                'table_name', 'metrics', \n                'family', 'c', \n                'qualifier', 'q'), \n            'test.prod.visits.total', \n            '123456') ")
public class PutUDF
extends UDF {
    private static final Logger LOG = Logger.getLogger(PutUDF.class);

    public String evaluate(Map<String, String> configMap, String key, String value) {
        HTableFactory.checkConfig(configMap);
        try {
            HTable table = HTableFactory.getHTable(configMap);
            Put thePut = new Put(key.getBytes());
            thePut.add(configMap.get(HTableFactory.FAMILY_TAG).getBytes(), configMap.get(HTableFactory.QUALIFIER_TAG).getBytes(), value.getBytes());
            table.put(thePut);
            table.flushCommits();
            return "Put " + key + ":" + value;
        }
        catch (Exception exc) {
            LOG.error((Object)"Error while doing HBase Puts");
            throw new RuntimeException(exc);
        }
    }

    public String evaluate(Map<String, String> configMap, Map<String, String> keyValueMap) {
        HTableFactory.checkConfig(configMap);
        try {
            ArrayList<Put> putList = new ArrayList<Put>();
            for (Map.Entry<String, String> keyValue : keyValueMap.entrySet()) {
                Put thePut = new Put(keyValue.getKey().getBytes());
                thePut.add(configMap.get(HTableFactory.FAMILY_TAG).getBytes(), configMap.get(HTableFactory.QUALIFIER_TAG).getBytes(), keyValue.getValue().getBytes());
                putList.add(thePut);
            }
            HTable table = HTableFactory.getHTable(configMap);
            table.put(putList);
            table.flushCommits();
            return "Put " + keyValueMap.toString();
        }
        catch (Exception exc) {
            LOG.error((Object)"Error while doing HBase Puts");
            throw new RuntimeException(exc);
        }
    }
}

