/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.hive.serde;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class FlumeJsonSerDe
implements SerDe {
    private static ValueMapper valueMapper = new ValueMapper();
    private static final Logger LOG = Logger.getLogger(FlumeJsonSerDe.class);
    private int numColumns;
    private StructObjectInspector rowOI;
    private List<String> columnNames;
    private Map<String, String> tableToJson;
    private Map<String, String> jsonToTable;
    private List<TypeInfo> columnTypes;
    Text outputRowText;

    public Object deserialize(Writable writable) throws SerDeException {
        String text = ((Text)writable).toString();
        String[] splits = text.split("\\t", 2);
        String timestamp = splits[0];
        String jsonText = splits[1];
        try {
            ObjectMapper jacksonParser = new ObjectMapper();
            JsonNode json = jacksonParser.readTree(jsonText);
        }
        catch (Throwable e) {
            e.printStackTrace();
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < this.columnNames.size(); ++i) {
                result.add(null);
            }
            return result;
        }
        ArrayList result = new ArrayList();
        return null;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowOI;
    }

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        try {
            assert (this.columnNames.size() == this.columnTypes.size());
            this.numColumns = this.columnNames.size();
            this.tableToJson = new HashMap<String, String>();
            this.jsonToTable = new HashMap<String, String>();
            String mappings = (String)tbl.get("mappings");
            if (mappings != null && !"".equals(mappings)) {
                for (String pair : mappings.split(",")) {
                    String[] split = pair.split(":");
                    this.tableToJson.put(split[0], split[1]);
                    this.jsonToTable.put(split[1], split[0]);
                }
            }
            ArrayList<Object> columnOIs = new ArrayList<Object>(this.columnNames.size());
            for (int c = 0; c < this.numColumns; ++c) {
                try {
                    columnOIs.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)((PrimitiveTypeInfo)this.columnTypes.get(c)).getPrimitiveCategory()));
                    continue;
                }
                catch (ClassCastException classCast) {
                    columnOIs.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector));
                }
            }
            this.rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(this.columnNames, columnOIs);
            this.outputRowText = new Text();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new SerDeException(t);
        }
    }

    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        throw new SerDeException("serialization into a protobuf object not yet supported");
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    private static class ValueMapper {
        private static Map<Object, Object> ValueMap = new HashMap<Object, Object>();

        private ValueMapper() {
        }

        static {
            ValueMap.put("impression", "impressions");
        }
    }
}

