/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.bloom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.log4j.Logger;

public class BloomFactory {
    private static final Logger LOG = Logger.getLogger(BloomFactory.class);
    private static Map<String, Filter> localBloomMap = new HashMap<String, Filter>();
    public static final int DEFAULT_NUM_ELEMENTS = 10000000;
    public static final double DEFAULT_FALSE_POS_PROB = 0.005;
    public static final int DEFAULT_HASH_TYPE = 0;
    public static final int NUMBER_OF_BLOOMS = 5;

    public static Filter NewBloomInstance() {
        return BloomFactory.NewBloomInstance(10000000, 0.005);
    }

    static Filter NewVesselBloom() {
        return new BloomFilter();
    }

    public static Filter NewBloomInstance(int expectedNumberOfElements, double falsePositiveProbability) {
        return BloomFactory.NewBloomInstance(Math.ceil(-(Math.log(falsePositiveProbability) / Math.log(2.0))) / Math.log(2.0), expectedNumberOfElements, (int)Math.ceil(-(Math.log(falsePositiveProbability) / Math.log(2.0))));
    }

    public static Filter NewBloomInstance(double c, int n, int k) {
        LOG.info((Object)("Creating new Bloom filter C = " + c + " N =  " + n + " K = " + k));
        BloomFilter dbf = new BloomFilter((int)Math.ceil(c * (double)n), k, 0);
        return dbf;
    }

    public static Filter GetBloomFilter(String str) {
        Filter bloom = BloomFactory.GetNamedBloomFilter(str);
        if (bloom == null) {
            try {
                bloom = BloomFactory.ReadBloomFromString(str);
                return bloom;
            }
            catch (IOException e) {
                LOG.error((Object)(" Unable to get bloom for string " + str));
                return null;
            }
        }
        return bloom;
    }

    public static Filter GetNamedBloomFilter(String name) {
        return localBloomMap.get(name);
    }

    public static void PutNamedBloomFilter(String name, Filter bloom) {
        localBloomMap.put(name, bloom);
    }

    public static Filter ReadBloomFromStream(InputStream stream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bufferArr = new byte[4096];
        int len = 0;
        while ((len = stream.read(bufferArr, 0, 4096)) > 0) {
            buffer.write(bufferArr, 0, len);
        }
        if (buffer.size() == 0) {
            return BloomFactory.NewBloomInstance();
        }
        return BloomFactory.ReadBloomFromString(new String(buffer.toByteArray()));
    }

    public static void WriteBloomToStream(OutputStream stream, Filter bloom) throws IOException {
        stream.write(BloomFactory.WriteBloomToString(bloom).getBytes());
        stream.flush();
    }

    public static Filter ReadBloomFromString(String str) throws IOException {
        if (str != null) {
            Filter filter = BloomFactory.NewVesselBloom();
            byte[] decoded = Base64.decodeBase64((byte[])str.getBytes());
            DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(decoded));
            filter.readFields((DataInput)dataInput);
            return filter;
        }
        return BloomFactory.NewBloomInstance();
    }

    public static String WriteBloomToString(Filter bloom) throws IOException {
        if (bloom != null) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            bloom.write((DataOutput)new DataOutputStream(buffer));
            byte[] encodedBloom = Base64.encodeBase64((byte[])buffer.toByteArray());
            return new String(encodedBloom);
        }
        return null;
    }
}

