/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.bloom;

import brickhouse.udf.bloom.BloomFactory;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.log4j.Logger;

@Description(name="bloom", value=" Constructs a BloomFilter by aggregating a set of keys \n _FUNC_(string key) \n")
public class BloomUDAF
extends UDAF {
    private static final Logger LOG = Logger.getLogger(BloomUDAF.class);

    public static class BloomUDAFEvaluator
    implements UDAFEvaluator {
        private Filter bloomFilter;

        public void init() {
            this.bloomFilter = BloomFactory.NewBloomInstance();
        }

        public boolean iterate(String key) {
            if (key != null) {
                if (this.bloomFilter == null) {
                    this.init();
                }
                this.bloomFilter.add(new Key(key.getBytes()));
            }
            return true;
        }

        public String terminatePartial() throws HiveException {
            return this.terminate();
        }

        public String terminate() throws HiveException {
            try {
                if (this.bloomFilter != null) {
                    return BloomFactory.WriteBloomToString(this.bloomFilter);
                }
                return null;
            }
            catch (IOException e) {
                LOG.error((Object)" Error while evaluating Bloom ", (Throwable)e);
                throw new HiveException("Error while evaluating Bloom");
            }
        }

        public boolean merge(String partial) {
            try {
                if (this.bloomFilter == null) {
                    this.bloomFilter = BloomFactory.ReadBloomFromString(partial);
                    return true;
                }
                Filter other = BloomFactory.ReadBloomFromString(partial);
                this.bloomFilter.or(other);
                return true;
            }
            catch (IOException e) {
                LOG.error((Object)" Error while evaluating Bloom ", (Throwable)e);
                return false;
            }
        }
    }
}

