/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.bloom;

import brickhouse.udf.bloom.BloomFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.log4j.Logger;

@Description(name="distribute_bloom", value=" Loads a bloomfilter from a file in distributed cache, and makes available as a named bloom. \n _FUNC_(string filename) \n_FUNC_(string filename, boolean returnEncoded) ")
@UDFType(deterministic=false)
public class DistributedBloomUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(DistributedBloomUDF.class);
    private StringObjectInspector fnameInspector;
    private BooleanObjectInspector boolInspector;

    static Filter loadBloom(String mapFilename) throws IOException {
        File mapFile = new File(mapFilename);
        if (!mapFile.exists()) {
            throw new FileNotFoundException(mapFilename + " not found.");
        }
        if (mapFile.isDirectory()) {
            String[] subFiles;
            for (String subFile : subFiles = mapFile.list()) {
                if (!subFile.endsWith("crc")) {
                    FileInputStream inStream = new FileInputStream(mapFilename + "/" + subFile);
                    return BloomFactory.ReadBloomFromStream(inStream);
                }
                LOG.info((Object)(" Ignoring CRC file " + mapFilename));
            }
            throw new FileNotFoundException(mapFilename + " not found.");
        }
        FileInputStream inStream = new FileInputStream(mapFilename);
        return BloomFactory.ReadBloomFromStream(inStream);
    }

    public String evaluate(String mapFilename, Boolean returnEncoded) throws HiveException {
        try {
            Filter bloom = BloomFactory.GetNamedBloomFilter(mapFilename);
            if (bloom == null) {
                bloom = DistributedBloomUDF.loadBloom(mapFilename);
                BloomFactory.PutNamedBloomFilter(mapFilename, bloom);
            }
            if (returnEncoded.booleanValue()) {
                return BloomFactory.WriteBloomToString(bloom);
            }
            return mapFilename;
        }
        catch (IOException ioExc) {
            throw new RuntimeException(ioExc);
        }
    }

    public String evaluate(String mapFilename) throws HiveException {
        return this.evaluate(mapFilename, false);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        String fname = this.fnameInspector.getPrimitiveJavaObject(arg0[0].get());
        boolean retEnc = false;
        if (this.boolInspector != null) {
            retEnc = this.boolInspector.get(arg0[1].get());
        }
        return this.evaluate(fname, retEnc);
    }

    public String getDisplayString(String[] arg0) {
        return "distributed_bloom( " + arg0[0] + " ) ";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length != 1 && arg0.length != 2) {
            throw new UDFArgumentException("distributed_bloom takes a string and a boolean argument");
        }
        if (arg0[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("distributed_bloom takes a string and a boolean argument");
        }
        PrimitiveObjectInspector primInsp = (PrimitiveObjectInspector)arg0[0];
        if (primInsp.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new UDFArgumentException("distributed_bloom takes a string and a boolean argument");
        }
        this.fnameInspector = (StringObjectInspector)primInsp;
        if (arg0.length > 1) {
            if (arg0[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentException("distributed_bloom takes a string and a boolean argument");
            }
            primInsp = (PrimitiveObjectInspector)arg0[1];
            if (primInsp.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN) {
                throw new UDFArgumentException("distributed_bloom takes a string and a boolean argument");
            }
            this.boolInspector = (BooleanObjectInspector)primInsp;
        }
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }
}

