/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;

public class ArrayIndexOfUDF
extends GenericUDF {
    private static final int ARRAY_IDX = 0;
    private static final int VALUE_IDX = 1;
    private static final int ARG_COUNT = 2;
    private static final String FUNC_NAME = "ARRAY_INDEX_OF";
    private ObjectInspector valueOI;
    private ListObjectInspector arrayOI;
    private ObjectInspector arrayElementOI;
    private IntWritable result;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentException("The function ARRAY_INDEX_OF accepts 2 arguments.");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(0, "\"LIST\" expected at function ARRAY_INDEX_OF, but \"" + arguments[0].getTypeName() + "\" " + "is found");
        }
        this.arrayOI = (ListObjectInspector)arguments[0];
        this.arrayElementOI = this.arrayOI.getListElementObjectInspector();
        this.valueOI = arguments[1];
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)this.arrayElementOI, (ObjectInspector)this.valueOI)) {
            throw new UDFArgumentTypeException(1, "\"" + this.arrayElementOI.getTypeName() + "\"" + " expected at function " + FUNC_NAME + ", but " + "\"" + this.valueOI.getTypeName() + "\"" + " is found");
        }
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)this.valueOI)) {
            throw new UDFArgumentException("The function ARRAY_INDEX_OF does not support comparison for \"" + this.valueOI.getTypeName() + "\"" + " types");
        }
        this.result = new IntWritable(-1);
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.result.set(-1);
        Object array = arguments[0].get();
        Object value = arguments[1].get();
        int arrayLength = this.arrayOI.getListLength(array);
        if (value == null || arrayLength <= 0) {
            return this.result;
        }
        for (int i = 0; i < arrayLength; ++i) {
            Object listElement = this.arrayOI.getListElement(array, i);
            if (listElement == null || ObjectInspectorUtils.compare((Object)value, (ObjectInspector)this.valueOI, (Object)listElement, (ObjectInspector)this.arrayElementOI) != 0) continue;
            this.result.set(i);
            break;
        }
        return this.result;
    }

    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return "array_index_of(" + children[0] + ", " + children[1] + ")";
    }
}

