/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;

public class ArrayIndexUDF
extends GenericUDF {
    private ListObjectInspector listInspector;
    private ObjectInspector elemInspector;
    private IntObjectInspector intInspector;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        Object list = arg0[0].get();
        int idx = this.intInspector.get(arg0[1].get());
        if (idx < 0) {
            idx = this.listInspector.getListLength(list) + idx;
        }
        Object unInsp = this.listInspector.getListElement(list, idx);
        return unInsp;
    }

    public String getDisplayString(String[] arg0) {
        return "array_index( " + arg0[0] + " , " + arg0[1] + " )";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length != 2) {
            throw new UDFArgumentException("array_index takes an array and an int as arguments");
        }
        if (arg0[0].getCategory() != ObjectInspector.Category.LIST || arg0[1].getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)arg0[1]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw new UDFArgumentException("array_index takes an array and an int as arguments");
        }
        this.listInspector = (ListObjectInspector)arg0[0];
        this.intInspector = (IntObjectInspector)arg0[1];
        return this.listInspector.getListElementObjectInspector();
    }
}

