/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.log4j.Logger;

@Description(name="intersect_array", value="_FUNC_(array1, array2, ...) - Returns the intersection of a set of arrays ")
public class ArrayIntersectUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(ArrayIntersectUDF.class);
    private StandardListObjectInspector retValInspector;
    private ListObjectInspector[] listInspectorArr;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        InspectableObject io;
        int i;
        HashMap<InspectableObject, InspectableObject> checkSet = new HashMap<InspectableObject, InspectableObject>();
        Object firstUndeferred = arg0[0].get();
        int firstArrSize = this.listInspectorArr[0].getListLength(firstUndeferred);
        for (i = 0; i < firstArrSize; ++i) {
            Object unInspected = this.listInspectorArr[0].getListElement(firstUndeferred, i);
            io = new InspectableObject(unInspected, this.listInspectorArr[0].getListElementObjectInspector());
            checkSet.put(io, io);
        }
        for (i = 1; i < arg0.length; ++i) {
            Object undeferred = arg0[i].get();
            HashMap newSet = new HashMap();
            for (int j = 0; j < this.listInspectorArr[i].getListLength(undeferred); ++j) {
                Object nonStd = this.listInspectorArr[i].getListElement(undeferred, j);
                InspectableObject stdInsp = new InspectableObject(nonStd, this.listInspectorArr[i].getListElementObjectInspector());
                if (!checkSet.containsKey(stdInsp)) continue;
                newSet.put(checkSet.get(stdInsp), checkSet.get(stdInsp));
            }
            checkSet = newSet;
        }
        List retVal = (List)this.retValInspector.create(0);
        Iterator i$ = checkSet.keySet().iterator();
        while (i$.hasNext()) {
            InspectableObject inspObj = io = i$.next();
            Object stdObj = ObjectInspectorUtils.copyToStandardObject((Object)inspObj.o, (ObjectInspector)inspObj.oi);
            retVal.add(stdObj);
        }
        return retVal;
    }

    public String getDisplayString(String[] arg0) {
        return "intersect_array(" + arg0[0] + ", " + arg0[1] + " )";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length < 2) {
            throw new UDFArgumentException(" Expecting at least two arrays as arguments ");
        }
        ObjectInspector first = arg0[0];
        this.listInspectorArr = new ListObjectInspector[arg0.length];
        if (first.getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException(" Expecting an array as first argument ");
        }
        this.listInspectorArr[0] = (ListObjectInspector)first;
        for (int i = 1; i < arg0.length; ++i) {
            if (arg0[i].getCategory() != ObjectInspector.Category.LIST) {
                throw new UDFArgumentException(" Expecting arrays arguments ");
            }
            ListObjectInspector checkInspector = (ListObjectInspector)arg0[i];
            if (!ObjectInspectorUtils.compareTypes((ObjectInspector)this.listInspectorArr[0].getListElementObjectInspector(), (ObjectInspector)checkInspector.getListElementObjectInspector())) {
                throw new UDFArgumentException(" Array types must match " + this.listInspectorArr[0].getTypeName() + " != " + checkInspector.getTypeName());
            }
            this.listInspectorArr[i] = checkInspector;
        }
        this.retValInspector = (StandardListObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)first);
        return this.retValInspector;
    }

    private class InspectableObject
    implements Comparable {
        public Object o;
        public ObjectInspector oi;

        public InspectableObject(Object o, ObjectInspector oi) {
            this.o = o;
            this.oi = oi;
        }

        public int hashCode() {
            return ObjectInspectorUtils.hashCode((Object)this.o, (ObjectInspector)this.oi);
        }

        public int compareTo(Object arg0) {
            InspectableObject otherInsp = (InspectableObject)arg0;
            return ObjectInspectorUtils.compare((Object)this.o, (ObjectInspector)this.oi, (Object)otherInsp.o, (ObjectInspector)otherInsp.oi);
        }

        public boolean equals(Object other) {
            return this.compareTo(other) == 0;
        }
    }
}

