/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;

public class ArrayRangeUDF
extends GenericUDF {
    private ListObjectInspector listInspector;
    private StandardListObjectInspector returnInspector;
    private IntObjectInspector firstIntInspector;
    private IntObjectInspector secondIntInspector;

    public int[] getIndexes(GenericUDF.DeferredObject[] arg0) throws HiveException {
        int length;
        int end;
        int start;
        if (this.secondIntInspector == null) {
            start = 0;
            length = end = this.firstIntInspector.get(arg0[1].get());
        } else {
            start = this.firstIntInspector.get(arg0[1].get());
            end = this.secondIntInspector.get(arg0[2].get());
            length = end - start + 1;
        }
        return new int[]{start, end, length};
    }

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        int[] indexes = this.getIndexes(arg0);
        int start = indexes[0];
        int end = indexes[1];
        int length = indexes[2];
        Object uninspListObj = arg0[0].get();
        int listSize = this.listInspector.getListLength(uninspListObj);
        Object truncatedListObj = this.returnInspector.create(length);
        for (int i = 0; i < end && i < listSize; ++i) {
            this.returnInspector.set(truncatedListObj, i, this.listInspector.getListElement(uninspListObj, i + start));
        }
        return truncatedListObj;
    }

    public String getDisplayString(String[] arg0) {
        return "array_range(" + arg0[0] + ", " + arg0[1] + " , " + arg0[1] + " )";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        ObjectInspector third;
        ObjectInspector first = arg0[0];
        if (first.getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException(" Expecting an array, one int and one optional int as arguments ");
        }
        this.listInspector = (ListObjectInspector)first;
        ObjectInspector second = arg0[1];
        if (second.getCategory() != ObjectInspector.Category.PRIMITIVE) throw new UDFArgumentException(" Expecting an array, one int and one optional int as arguments ");
        PrimitiveObjectInspector secondPrim = (PrimitiveObjectInspector)second;
        if (secondPrim.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw new UDFArgumentException(" Expecting an array, one int and one optional int as arguments ");
        }
        this.firstIntInspector = (IntObjectInspector)second;
        if (arg0.length > 2 && (third = arg0[2]) != null) {
            if (third.getCategory() != ObjectInspector.Category.PRIMITIVE) throw new UDFArgumentException(" Expecting an array, one int and one optional int as arguments ");
            PrimitiveObjectInspector thirdPrim = (PrimitiveObjectInspector)third;
            if (thirdPrim.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) throw new UDFArgumentException(" Expecting an array, one int and one optional int as arguments ");
            this.secondIntInspector = (IntObjectInspector)third;
        }
        this.returnInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.listInspector.getListElementObjectInspector());
        return this.returnInspector;
    }
}

