/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.log4j.Logger;

public class CastArrayUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(CastArrayUDF.class);
    private ListObjectInspector listInspector;
    private PrimitiveObjectInspector fromInspector;
    private PrimitiveObjectInspector toInspector;
    private String returnElemType;

    public List<Object> evaluate(List<Object> uninspArray) {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (Object uninsp : uninspArray) {
            LOG.info((Object)("Uninspected = " + uninsp));
            Object stdObject = ObjectInspectorUtils.copyToStandardJavaObject((Object)uninsp, (ObjectInspector)this.fromInspector);
            Object castedObject = this.coerceObject(stdObject);
            newList.add(castedObject);
        }
        return newList;
    }

    private Object coerceObject(Object stdObj) {
        LOG.info((Object)("Casting " + stdObj + " from " + this.fromInspector.getPrimitiveCategory() + " to " + this.toInspector.getPrimitiveCategory() + " of type " + this.toInspector.getTypeName()));
        if (stdObj == null) {
            return null;
        }
        switch (this.fromInspector.getPrimitiveCategory()) {
            case STRING: {
                String fromStr = (String)stdObj;
                switch (this.toInspector.getPrimitiveCategory()) {
                    case STRING: {
                        return fromStr;
                    }
                    case BOOLEAN: {
                        if (fromStr.equals("true")) {
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                    case BYTE: 
                    case SHORT: {
                        return Short.parseShort(fromStr);
                    }
                    case INT: {
                        return Integer.parseInt(fromStr);
                    }
                    case LONG: {
                        return Long.parseLong(fromStr);
                    }
                    case FLOAT: {
                        return Float.valueOf(Float.parseFloat(fromStr));
                    }
                    case DOUBLE: {
                        return Double.parseDouble(fromStr);
                    }
                    case TIMESTAMP: 
                    case VOID: {
                        return null;
                    }
                }
                return null;
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                Number fromNum = (Number)stdObj;
                switch (this.toInspector.getPrimitiveCategory()) {
                    case SHORT: {
                        return fromNum.shortValue();
                    }
                    case INT: {
                        return fromNum.intValue();
                    }
                    case LONG: {
                        return fromNum.longValue();
                    }
                    case FLOAT: {
                        return Float.valueOf(fromNum.floatValue());
                    }
                    case DOUBLE: {
                        return fromNum.doubleValue();
                    }
                    case STRING: {
                        return fromNum.toString();
                    }
                    case TIMESTAMP: 
                    case VOID: {
                        return null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        List argList = this.listInspector.getList(arg0[0].get());
        if (argList != null) {
            return this.evaluate(argList);
        }
        return null;
    }

    public String getDisplayString(String[] arg0) {
        StringBuilder sb = new StringBuilder("cast_array(");
        sb.append(arg0[0]);
        if (arg0.length > 1) {
            sb.append(" , ");
            sb.append(arg0[1]);
        }
        return sb.toString();
    }

    private static PrimitiveObjectInspector GetObjectInspectorForTypeName(String typeString) {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeString);
        LOG.info((Object)("Type for " + typeString + " is " + typeInfo));
        return (PrimitiveObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0[0].getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("cast_array() takes a list, and an optional type to cast to.");
        }
        this.listInspector = (ListObjectInspector)arg0[0];
        if (this.listInspector.getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("cast_array() only handles arrays of primitives.");
        }
        this.fromInspector = (PrimitiveObjectInspector)this.listInspector.getListElementObjectInspector();
        LOG.info((Object)(" Cast Array input type is " + this.listInspector + " element = " + this.listInspector.getListElementObjectInspector()));
        if (arg0.length > 1) {
            if (!(arg0[1] instanceof ConstantObjectInspector) || !(arg0[1] instanceof StringObjectInspector)) {
                throw new UDFArgumentException("cast_array() takes a list, and an optional type to cast to.");
            }
            ConstantObjectInspector constInsp = (ConstantObjectInspector)arg0[1];
            this.returnElemType = constInsp.getWritableConstantValue().toString();
            this.toInspector = CastArrayUDF.GetObjectInspectorForTypeName(this.returnElemType);
            StandardListObjectInspector returnType = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.toInspector);
            return returnType;
        }
        this.returnElemType = "string";
        this.toInspector = CastArrayUDF.GetObjectInspectorForTypeName(this.returnElemType);
        StandardListObjectInspector returnType = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        return returnType;
    }
}

