/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.log4j.Logger;

public class CastMapUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(CastMapUDF.class);
    private MapObjectInspector mapInspector;

    public Map<String, String> evaluate(Map<Object, Object> strMap) {
        TreeMap<String, String> newMap = new TreeMap<String, String>();
        for (Object keyObj : strMap.keySet()) {
            newMap.put(keyObj.toString(), strMap.get(keyObj).toString());
        }
        return newMap;
    }

    public Map<String, String> evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        Map argMap = this.mapInspector.getMap(arg0[0].get());
        if (argMap != null) {
            return this.evaluate(argMap);
        }
        return null;
    }

    public String getDisplayString(String[] arg0) {
        return "cast_map()";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        this.mapInspector = (MapObjectInspector)arg0[0];
        LOG.info((Object)(" Cast Map input type is " + this.mapInspector + " key = " + this.mapInspector.getMapKeyObjectInspector().getTypeName() + " value = " + this.mapInspector.getMapValueObjectInspector().getTypeName()));
        StandardMapObjectInspector returnType = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        return returnType;
    }
}

