/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.log4j.Logger;

@Description(name="collect_max", value="_FUNC_(x, val, n) - Returns an map of the max N elements in the aggregation group ")
public class CollectMaxUDAF
extends AbstractGenericUDAFResolver {
    private static final Logger LOG = Logger.getLogger(CollectMaxUDAF.class);
    public static int DEFAULT_MAX_VALUES = 20;

    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        return new MapCollectMaxUDAFEvaluator();
    }

    public static class MapCollectMaxUDAFEvaluator
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector inputKeyOI;
        private PrimitiveObjectInspector inputValOI;
        private IntObjectInspector nvOI;
        private StandardMapObjectInspector moi;
        private StandardMapObjectInspector internalMergeOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            LOG.info((Object)(" CollectMaxUDAF.init() - Mode= " + m.name()));
            for (int i = 0; i < parameters.length; ++i) {
                LOG.info((Object)(" ObjectInspector[ " + i + " ] = " + parameters[0]));
            }
            if (parameters.length > 2) {
                this.nvOI = (IntObjectInspector)parameters[2];
            }
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1) {
                this.inputKeyOI = (PrimitiveObjectInspector)parameters[0];
                this.inputValOI = (PrimitiveObjectInspector)parameters[1];
            } else if (!(parameters[0] instanceof StandardMapObjectInspector)) {
                LOG.info((Object)" Not a standard map OjbectInspector ");
                this.inputKeyOI = (PrimitiveObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)parameters[0]);
                this.inputValOI = (PrimitiveObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)parameters[1]);
            } else {
                this.internalMergeOI = (StandardMapObjectInspector)parameters[0];
                this.inputKeyOI = (PrimitiveObjectInspector)this.internalMergeOI.getMapKeyObjectInspector();
                this.inputValOI = (PrimitiveObjectInspector)this.internalMergeOI.getMapValueObjectInspector();
            }
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector);
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            MapAggBuffer buff = new MapAggBuffer();
            this.reset(buff);
            return buff;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object k = parameters[0];
            Object v = parameters[1];
            if (k == null || v == null) {
                throw new HiveException("Kay or value is null.  k = " + k + " , v = " + v);
            }
            if (k != null) {
                MapAggBuffer myagg = (MapAggBuffer)agg;
                if (parameters.length > 2) {
                    Object numValsObj = parameters[2];
                    int nv = this.nvOI.get(numValsObj);
                    myagg.setNumValues(nv);
                }
                this.putIntoSet(k, v, myagg);
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            MapAggBuffer myagg = (MapAggBuffer)agg;
            Map partialResult = this.internalMergeOI.getMap(partial);
            Iterator i$ = partialResult.keySet().iterator();
            while (i$.hasNext()) {
                StringObjectInspector strInsp = (StringObjectInspector)this.inputKeyOI;
                Object key = i$.next();
                String keyCopy = strInsp.getPrimitiveJavaObject(key);
                if (!keyCopy.equals("NumValues")) continue;
                DoubleObjectInspector dblInsp = (DoubleObjectInspector)this.inputValOI;
                Object val = partialResult.get(key);
                Double valCopy = dblInsp.get(val);
                myagg.setNumValues(valCopy.intValue());
                partialResult.remove(key);
                break;
            }
            for (Object i : partialResult.keySet()) {
                this.putIntoSet(i, partialResult.get(i), myagg);
            }
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            MapAggBuffer arrayBuff = (MapAggBuffer)buff;
            arrayBuff.reset();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggBuffer myagg = (MapAggBuffer)agg;
            return myagg.getValueMap();
        }

        private void putIntoSet(Object key, Object val, MapAggBuffer myagg) {
            StringObjectInspector strInsp = (StringObjectInspector)this.inputKeyOI;
            DoubleObjectInspector dblInsp = (DoubleObjectInspector)this.inputValOI;
            String keyCopy = strInsp.getPrimitiveJavaObject(key);
            Double valCopy = dblInsp.get(val);
            myagg.addValue(keyCopy, valCopy);
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggBuffer myagg = (MapAggBuffer)agg;
            Map<String, Double> vals = myagg.getValueMap();
            vals.put("NumValues", Double.valueOf(myagg.numValues));
            return vals;
        }

        static class MapAggBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            private TreeSet<SortedKeyValue> sortedValues = new TreeSet();
            private int numValues = DEFAULT_MAX_VALUES;

            MapAggBuffer() {
            }

            public void setNumValues(int nv) {
                this.numValues = nv;
            }

            public void addValue(String key, Double value) {
                if (this.sortedValues.size() < this.numValues) {
                    this.sortedValues.add(new SortedKeyValue(key, value));
                } else {
                    SortedKeyValue minValue = this.sortedValues.last();
                    if (value > minValue.getValue()) {
                        this.sortedValues.remove(minValue);
                        this.sortedValues.add(new SortedKeyValue(key, value));
                    }
                }
            }

            public void fromMap(Map<Object, Object> fromMap) {
                for (Object kObj : fromMap.keySet()) {
                    Object val = fromMap.get(kObj);
                    this.addValue((String)kObj, (Double)val);
                }
            }

            public Map<String, Double> getValueMap() {
                LinkedHashMap<String, Double> reverseOrderMap = new LinkedHashMap<String, Double>();
                for (SortedKeyValue kv : this.sortedValues) {
                    reverseOrderMap.put(kv.key, kv.value);
                }
                return reverseOrderMap;
            }

            public void reset() {
                this.sortedValues.clear();
            }
        }

        public static class SortedKeyValue
        implements Comparable {
            private String key;
            private Double value;

            public SortedKeyValue(String key, Double val) {
                this.key = key;
                this.value = val;
            }

            public boolean equals(Object other) {
                if (!(other instanceof SortedKeyValue)) {
                    return false;
                }
                SortedKeyValue otherKV = (SortedKeyValue)other;
                return this.key.equals(otherKV.key);
            }

            public String getKey() {
                return this.key;
            }

            public Double getValue() {
                return this.value;
            }

            public int compareTo(Object arg1) {
                SortedKeyValue kv0 = this;
                SortedKeyValue kv1 = (SortedKeyValue)arg1;
                if (kv0.value != kv1.value) {
                    if (kv0.value > kv1.value) {
                        return -1;
                    }
                    if (kv0.value < kv1.value) {
                        return 1;
                    }
                    return kv0.key.compareTo(kv1.key);
                }
                return kv0.key.compareTo(kv1.key);
            }
        }
    }
}

