/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="collect", value="_FUNC_(x) - Returns an array of all the elements in the aggregation group ")
public class CollectUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1 && parameters.length != 2) {
            throw new UDFArgumentTypeException(parameters.length - 1, "One argument is expected to return an Array, Two arguments are expected for a Map.");
        }
        if (parameters.length == 1) {
            return new ArrayCollectUDAFEvaluator();
        }
        return new MapCollectUDAFEvaluator();
    }

    public static class MapCollectUDAFEvaluator
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector inputKeyOI;
        private ObjectInspector inputValOI;
        private StandardMapObjectInspector moi;
        private StandardMapObjectInspector internalMergeOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1) {
                this.inputKeyOI = (PrimitiveObjectInspector)parameters[0];
                this.inputValOI = parameters[1];
                return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputKeyOI), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputValOI));
            }
            if (!(parameters[0] instanceof StandardMapObjectInspector)) {
                this.inputKeyOI = (PrimitiveObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)parameters[0]);
                this.inputValOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)parameters[0]);
                return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)this.inputKeyOI, (ObjectInspector)this.inputValOI);
            }
            this.internalMergeOI = (StandardMapObjectInspector)parameters[0];
            this.inputKeyOI = (PrimitiveObjectInspector)this.internalMergeOI.getMapKeyObjectInspector();
            this.inputValOI = this.internalMergeOI.getMapValueObjectInspector();
            this.moi = (StandardMapObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.internalMergeOI);
            return this.moi;
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            MapAggBuffer buff = new MapAggBuffer();
            this.reset(buff);
            return buff;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object k = parameters[0];
            Object v = parameters[1];
            if (k != null) {
                MapAggBuffer myagg = (MapAggBuffer)agg;
                this.putIntoSet(k, v, myagg);
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            MapAggBuffer myagg = (MapAggBuffer)agg;
            HashMap partialResult = (HashMap)this.internalMergeOI.getMap(partial);
            for (Object i : partialResult.keySet()) {
                this.putIntoSet(i, partialResult.get(i), myagg);
            }
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            MapAggBuffer arrayBuff = (MapAggBuffer)buff;
            arrayBuff.collectMap = new HashMap();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggBuffer myagg = (MapAggBuffer)agg;
            HashMap<Object, Object> ret = new HashMap<Object, Object>(myagg.collectMap);
            return ret;
        }

        private void putIntoSet(Object key, Object val, MapAggBuffer myagg) {
            Object keyCopy = ObjectInspectorUtils.copyToStandardObject((Object)key, (ObjectInspector)this.inputKeyOI);
            Object valCopy = ObjectInspectorUtils.copyToStandardObject((Object)val, (ObjectInspector)this.inputValOI);
            myagg.collectMap.put(keyCopy, valCopy);
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggBuffer myagg = (MapAggBuffer)agg;
            HashMap<Object, Object> ret = new HashMap<Object, Object>(myagg.collectMap);
            return ret;
        }

        static class MapAggBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            HashMap<Object, Object> collectMap = new HashMap();

            MapAggBuffer() {
            }
        }
    }

    public static class ArrayCollectUDAFEvaluator
    extends GenericUDAFEvaluator {
        private ObjectInspector inputOI;
        private StandardListObjectInspector loi;
        private StandardListObjectInspector internalMergeOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1) {
                this.inputOI = parameters[0];
                return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputOI));
            }
            if (!(parameters[0] instanceof StandardListObjectInspector)) {
                this.inputOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)parameters[0]);
                return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.inputOI);
            }
            this.internalMergeOI = (StandardListObjectInspector)parameters[0];
            this.inputOI = this.internalMergeOI.getListElementObjectInspector();
            this.loi = (StandardListObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.internalMergeOI);
            return this.loi;
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            ArrayAggBuffer buff = new ArrayAggBuffer();
            this.reset(buff);
            return buff;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object p = parameters[0];
            if (p != null) {
                ArrayAggBuffer myagg = (ArrayAggBuffer)agg;
                this.putIntoSet(p, myagg);
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            ArrayAggBuffer myagg = (ArrayAggBuffer)agg;
            ArrayList partialResult = (ArrayList)this.internalMergeOI.getList(partial);
            for (Object i : partialResult) {
                this.putIntoSet(i, myagg);
            }
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            ArrayAggBuffer arrayBuff = (ArrayAggBuffer)buff;
            arrayBuff.collectArray = new ArrayList();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ArrayAggBuffer myagg = (ArrayAggBuffer)agg;
            ArrayList ret = new ArrayList(myagg.collectArray.size());
            ret.addAll(myagg.collectArray);
            return ret;
        }

        private void putIntoSet(Object p, ArrayAggBuffer myagg) {
            Object pCopy = ObjectInspectorUtils.copyToStandardObject((Object)p, (ObjectInspector)this.inputOI);
            myagg.collectArray.add(pCopy);
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ArrayAggBuffer myagg = (ArrayAggBuffer)agg;
            ArrayList ret = new ArrayList(myagg.collectArray.size());
            ret.addAll(myagg.collectArray);
            return ret;
        }

        static class ArrayAggBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            ArrayList collectArray = new ArrayList();

            ArrayAggBuffer() {
            }
        }
    }
}

