/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;

@Description(name="combine", value="_FUNC_(a,b) - Returns a combined list of two lists, or a combined map of two maps ")
public class CombineUDF
extends GenericUDF {
    private ObjectInspector.Category category;
    private StandardListObjectInspector stdListInspector;
    private StandardMapObjectInspector stdMapInspector;
    private ListObjectInspector[] listInspectorList;
    private MapObjectInspector[] mapInspectorList;

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        if (this.category == ObjectInspector.Category.LIST) {
            int currSize = 0;
            Object theList = this.stdListInspector.create(currSize);
            int lastIdx = 0;
            for (int i = 0; i < args.length; ++i) {
                List addList = this.listInspectorList[i].getList(args[i].get());
                this.stdListInspector.resize(theList, currSize += addList.size());
                for (int j = 0; j < addList.size(); ++j) {
                    Object uninspObj = addList.get(j);
                    Object stdObj = ObjectInspectorUtils.copyToStandardObject(uninspObj, (ObjectInspector)this.listInspectorList[i].getListElementObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                    this.stdListInspector.set(theList, lastIdx + j, stdObj);
                }
                lastIdx += addList.size();
            }
            return theList;
        }
        if (this.category == ObjectInspector.Category.MAP) {
            Object theMap = this.stdMapInspector.create();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].get() == null) continue;
                Map addMap = this.mapInspectorList[i].getMap(args[i].get());
                Iterator i$ = addMap.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry uninspObj;
                    Map.Entry uninspEntry = uninspObj = i$.next();
                    Object stdKey = ObjectInspectorUtils.copyToStandardObject(uninspEntry.getKey(), (ObjectInspector)this.mapInspectorList[i].getMapKeyObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                    Object stdVal = ObjectInspectorUtils.copyToStandardObject(uninspEntry.getValue(), (ObjectInspector)this.mapInspectorList[i].getMapValueObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                    this.stdMapInspector.put(theMap, stdKey, stdVal);
                }
            }
            return theMap;
        }
        throw new HiveException(" Only maps or lists are supported ");
    }

    public String getDisplayString(String[] args) {
        StringBuilder sb = new StringBuilder("combine( ");
        for (int i = 0; i < args.length - 1; ++i) {
            sb.append(args[i]);
            sb.append(",");
        }
        sb.append(args[args.length - 1]);
        sb.append(")");
        return sb.toString();
    }

    public ObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length < 2) {
            throw new UDFArgumentException("Usage: combine takes 2 or more maps or lists, and combines the result");
        }
        ObjectInspector first = args[0];
        this.category = first.getCategory();
        if (this.category == ObjectInspector.Category.LIST) {
            this.listInspectorList = new ListObjectInspector[args.length];
            this.listInspectorList[0] = (ListObjectInspector)first;
            for (int i = 1; i < args.length; ++i) {
                ObjectInspector argInsp = args[i];
                if (!ObjectInspectorUtils.compareTypes((ObjectInspector)first, (ObjectInspector)argInsp)) {
                    throw new UDFArgumentException("Combine must either be all maps or all lists of the same type");
                }
                this.listInspectorList[i] = (ListObjectInspector)argInsp;
            }
            this.stdListInspector = (StandardListObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)first, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return this.stdListInspector;
        }
        if (this.category == ObjectInspector.Category.MAP) {
            this.mapInspectorList = new MapObjectInspector[args.length];
            this.mapInspectorList[0] = (MapObjectInspector)first;
            for (int i = 1; i < args.length; ++i) {
                ObjectInspector argInsp = args[i];
                if (!ObjectInspectorUtils.compareTypes((ObjectInspector)first, (ObjectInspector)argInsp)) {
                    throw new UDFArgumentException("Combine must either be all maps or all lists of the same type");
                }
                this.mapInspectorList[i] = (MapObjectInspector)argInsp;
            }
            this.stdMapInspector = (StandardMapObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)first, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return this.stdMapInspector;
        }
        throw new UDFArgumentException(" combine only takes maps or lists.");
    }
}

