/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.log4j.Logger;

@Description(name="combine_unique", value="_FUNC_(x) - Returns an array of all distinct elements of all lists in the aggregation group ")
public class CombineUniqueUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "One argument is expected, taking an array as an argument");
        }
        if (!parameters[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(parameters.length - 1, "One argument is expected, taking an array as an argument");
        }
        return new CombineUniqueUDAFEvaluator();
    }

    public static class CombineUniqueUDAFEvaluator
    extends GenericUDAFEvaluator {
        private static final Logger LOG = Logger.getLogger(CombineUniqueUDAFEvaluator.class);
        private ListObjectInspector inputOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            this.inputOI = (ListObjectInspector)parameters[0];
            AbstractPrimitiveJavaObjectInspector elemInsp = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)((PrimitiveObjectInspector)this.inputOI.getListElementObjectInspector()).getPrimitiveCategory());
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)elemInsp);
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            UniqueSetBuffer buff = new UniqueSetBuffer();
            this.reset(buff);
            return buff;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object p = parameters[0];
            if (p != null) {
                UniqueSetBuffer myagg = (UniqueSetBuffer)agg;
                this.putIntoSet(p, myagg);
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            UniqueSetBuffer myagg = (UniqueSetBuffer)agg;
            this.putIntoSet(partial, myagg);
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            UniqueSetBuffer arrayBuff = (UniqueSetBuffer)buff;
            arrayBuff.collectSet = new HashSet();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            UniqueSetBuffer myagg = (UniqueSetBuffer)agg;
            ArrayList ret = new ArrayList(myagg.collectSet.size());
            ret.addAll(myagg.collectSet);
            return ret;
        }

        private void putIntoSet(Object p, UniqueSetBuffer myagg) {
            List pList = this.inputOI.getList(p);
            ObjectInspector objInsp = this.inputOI.getListElementObjectInspector();
            for (Object obj : pList) {
                Object realObj = ((PrimitiveObjectInspector)objInsp).getPrimitiveJavaObject(obj);
                myagg.collectSet.add(realObj);
            }
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            UniqueSetBuffer myagg = (UniqueSetBuffer)agg;
            ArrayList ret = new ArrayList(myagg.collectSet.size());
            ret.addAll(myagg.collectSet);
            return ret;
        }

        static class UniqueSetBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            HashSet collectSet = new HashSet();

            UniqueSetBuffer() {
            }
        }
    }
}

