/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;

@Description(name="conditional_emit", value="_FUNC_(a,b) - Emit features of a row according to various conditions ")
public class ConditionalEmit
extends GenericUDTF {
    private ListObjectInspector conditionInspector = null;
    private ListObjectInspector featureInspector = null;
    private final Object[] forwardListObj = new Object[1];

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("conditional_emit  takes 2 arguments, array<boolean>, array<string>");
        }
        if (argOIs[0].getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("conditional_emit  takes 2 arguments, array<boolean>, array<string>");
        }
        this.conditionInspector = (ListObjectInspector)argOIs[0];
        if (this.conditionInspector.getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("conditional_emit  takes 2 arguments, array<boolean>, array<string>");
        }
        PrimitiveObjectInspector boolInspector = (PrimitiveObjectInspector)this.conditionInspector.getListElementObjectInspector();
        if (boolInspector.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN) {
            throw new UDFArgumentException("conditional_emit  takes 2 arguments, array<boolean>, array<string>");
        }
        this.featureInspector = (ListObjectInspector)argOIs[1];
        if (this.featureInspector.getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("conditional_emit  takes 2 arguments, array<boolean>, array<string>");
        }
        PrimitiveObjectInspector strInspector = (PrimitiveObjectInspector)this.featureInspector.getListElementObjectInspector();
        if (strInspector.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new UDFArgumentException("conditional_emit  takes 2 arguments, array<boolean>, array<string>");
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("feature");
        ArrayList<JavaStringObjectInspector> fieldOIs = new ArrayList<JavaStringObjectInspector>();
        fieldOIs.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        List conditionList = this.conditionInspector.getList(args[0]);
        List featureList = this.featureInspector.getList(args[1]);
        if (conditionList.size() != featureList.size()) {
            throw new HiveException(" condition_emit, lists must be of same length");
        }
        for (int i = 0; i < conditionList.size(); ++i) {
            Boolean predicate;
            BooleanObjectInspector predInspector = (BooleanObjectInspector)this.conditionInspector.getListElementObjectInspector();
            Object checkGet = conditionList.get(i);
            if (checkGet == null || !(predicate = Boolean.valueOf(predInspector.get(checkGet))).booleanValue()) continue;
            StringObjectInspector featureNameInspector = (StringObjectInspector)this.featureInspector.getListElementObjectInspector();
            String featureName = featureNameInspector.getPrimitiveJavaObject(featureList.get(i));
            this.forwardListObj[0] = featureName;
            this.forward(this.forwardListObj);
        }
    }

    public void close() throws HiveException {
    }
}

