/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="first_index", value="_FUNC_(x) - Last value in an array ")
public class FirstIndexUDF
extends GenericUDF {
    private ListObjectInspector listInspector;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        Object list = arg0[0].get();
        if (this.listInspector.getListLength(list) > 0) {
            Object unInsp = this.listInspector.getListElement(list, 0);
            return unInsp;
        }
        return null;
    }

    public String getDisplayString(String[] arg0) {
        return "first_index( " + arg0[0] + " )";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length != 1) {
            throw new UDFArgumentException("first_index takes an array as an argument.");
        }
        if (arg0[0].getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("first_index takes an array as an argument.");
        }
        this.listInspector = (ListObjectInspector)arg0[0];
        return this.listInspector.getListElementObjectInspector();
    }
}

