/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;

@Description(name="group_count", value=" A sequence id for all rows with the same value for a specific grouping")
public class GroupCountUDF
extends UDF {
    private String lastGrouping = null;
    private int lastCount = 0;

    public Integer evaluate(String grouping) {
        if (this.lastGrouping == null) {
            this.lastGrouping = grouping;
            this.lastCount = 1;
            return 0;
        }
        if (this.lastGrouping != null && this.lastGrouping.equals(grouping)) {
            int retVal = this.lastCount++;
            return retVal;
        }
        this.lastCount = 1;
        this.lastGrouping = grouping;
        return 0;
    }
}

