/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.List;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;

public class JoinArrayUDF
extends GenericUDF {
    private ListObjectInspector listInspector;
    private StringObjectInspector strInspector;

    public String evaluate(List<Object> strArray, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strArray.size(); ++i) {
            StringObjectInspector strInspector = (StringObjectInspector)this.listInspector.getListElementObjectInspector();
            sb.append(strInspector.getPrimitiveJavaObject(strArray.get(i)));
            if (i >= strArray.size() - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        List objList = this.listInspector.getList(arg0[0].get());
        return this.evaluate(objList, this.strInspector.getPrimitiveJavaObject(arg0[1].get()));
    }

    public String getDisplayString(String[] arg0) {
        return "join_array()";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        this.listInspector = (ListObjectInspector)arg0[0];
        this.strInspector = (StringObjectInspector)arg0[1];
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }
}

