/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="last_index", value="_FUNC_(x) - Last value in an array ")
public class LastIndexUDF
extends GenericUDF {
    private ListObjectInspector listInspector;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        Object list = arg0[0].get();
        int lastIdx = this.listInspector.getListLength(list) - 1;
        if (lastIdx >= 0) {
            Object unInsp = this.listInspector.getListElement(list, lastIdx);
            return unInsp;
        }
        return null;
    }

    public String getDisplayString(String[] arg0) {
        return "last_index( " + arg0[0] + " )";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length != 1) {
            throw new UDFArgumentException("last_index takes an array as an argument.");
        }
        if (arg0[0].getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("last_index takes an array as an argument.");
        }
        this.listInspector = (ListObjectInspector)arg0[0];
        return this.listInspector.getListElementObjectInspector();
    }
}

