/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.log4j.Logger;

@Description(name="map_filter_keys", value="_FUNC_(map, key_array) - Returns the filtered entries of a map corresponding to a given set of keys ")
public class MapFilterKeysUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(MapFilterKeysUDF.class);
    private MapObjectInspector mapInspector;
    private StandardMapObjectInspector retValInspector;
    private ListObjectInspector keyListInspector;

    private Map stdKeys(Map inspectMap) {
        HashMap objMap = new HashMap();
        for (Object inspKey : inspectMap.keySet()) {
            Object objKey = ((PrimitiveObjectInspector)this.mapInspector.getMapKeyObjectInspector()).getPrimitiveJavaObject(inspKey);
            objMap.put(objKey, inspKey);
        }
        return objMap;
    }

    private List inspectList(List inspectList) {
        ArrayList<Object> objList = new ArrayList<Object>();
        for (Object inspKey : inspectList) {
            Object objKey = ((PrimitiveObjectInspector)this.keyListInspector.getListElementObjectInspector()).getPrimitiveJavaObject(inspKey);
            objList.add(objKey);
        }
        return objList;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        Map hiveMap = this.mapInspector.getMap(arg0[0].get());
        List keyValues = this.inspectList(this.keyListInspector.getList(arg0[1].get()));
        Map stdKeys = this.stdKeys(hiveMap);
        Map retVal = (Map)this.retValInspector.create();
        for (Object keyObj : keyValues) {
            if (!stdKeys.containsKey(keyObj)) continue;
            Object hiveKey = stdKeys.get(keyObj);
            Object hiveVal = hiveMap.get(hiveKey);
            Object keyStd = ObjectInspectorUtils.copyToStandardObject(hiveKey, (ObjectInspector)this.mapInspector.getMapKeyObjectInspector());
            Object valStd = ObjectInspectorUtils.copyToStandardObject(hiveVal, (ObjectInspector)this.mapInspector.getMapValueObjectInspector());
            retVal.put(keyStd, valStd);
        }
        return retVal;
    }

    public String getDisplayString(String[] arg0) {
        return "map_filter_keys(" + arg0[0] + ", " + arg0[1] + " )";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        ObjectInspector first = arg0[0];
        if (first.getCategory() != ObjectInspector.Category.MAP) {
            throw new UDFArgumentException(" Expecting a map as first argument ");
        }
        this.mapInspector = (MapObjectInspector)first;
        ObjectInspector second = arg0[1];
        if (second.getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException(" Expecting a list as second argument ");
        }
        this.keyListInspector = (ListObjectInspector)second;
        if (this.keyListInspector.getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException(" Expecting a primitive as key list elements.");
        }
        ObjectInspector mapKeyInspector = this.mapInspector.getMapKeyObjectInspector();
        if (mapKeyInspector.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException(" Expecting a primitive as map key elements.");
        }
        LOG.info((Object)(" Map has key type " + mapKeyInspector.getTypeName()));
        LOG.info((Object)(" Key list has key type " + this.keyListInspector.getTypeName()));
        if (((PrimitiveObjectInspector)this.keyListInspector.getListElementObjectInspector()).getPrimitiveCategory() != ((PrimitiveObjectInspector)mapKeyInspector).getPrimitiveCategory()) {
            throw new UDFArgumentException(" Expecting keys to be of same types.");
        }
        this.retValInspector = (StandardMapObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)first);
        return this.retValInspector;
    }
}

