/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.log4j.Logger;

public class MapIndexUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(MapIndexUDF.class);
    private PrimitiveObjectInspector keyInspector;
    private MapObjectInspector mapInspector;

    public Double evaluate(Map<String, Double> map, String key) throws IOException {
        return map.get(key);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        Object mapObj = arg0[0].get();
        Object keyObj = arg0[1].get();
        Object mapVal = this.mapInspector.getMapValueElement(mapObj, keyObj);
        return mapVal;
    }

    public String getDisplayString(String[] arg0) {
        return "map_index( " + arg0[0] + " , " + arg0[1] + ")";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length != 2) {
            throw new UDFArgumentException("Usage : map_index( map, key)");
        }
        if (arg0[0].getCategory() != ObjectInspector.Category.MAP || arg0[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("Usage : map_index( map, key) - First argument must be a map, second must be a matching key");
        }
        this.mapInspector = (MapObjectInspector)arg0[0];
        this.keyInspector = (PrimitiveObjectInspector)arg0[1];
        if (((PrimitiveObjectInspector)this.mapInspector.getMapKeyObjectInspector()).getPrimitiveCategory() != this.keyInspector.getPrimitiveCategory()) {
            throw new UDFArgumentException("Usage : map_index( map, key) - First argument must be a map, second must be a matching key");
        }
        return this.mapInspector.getMapValueObjectInspector();
    }
}

