/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;

@Description(name="map_key_values", value="_FUNC_(map) - Returns a Array of key-value pairs contained in a Map")
public class MapKeyValuesUDF
extends GenericUDF {
    private MapObjectInspector moi;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentException("Usage : map_key_values( map) ");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            throw new UDFArgumentException("Usage : map_key_values( map) ");
        }
        this.moi = (MapObjectInspector)arguments[0];
        ArrayList<String> structFieldNames = new ArrayList<String>();
        ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>();
        structFieldNames.add("key");
        structFieldObjectInspectors.add(this.moi.getMapKeyObjectInspector());
        structFieldNames.add("value");
        structFieldObjectInspectors.add(this.moi.getMapValueObjectInspector());
        StandardStructObjectInspector keyOI = ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, structFieldObjectInspectors);
        StandardListObjectInspector arrayOI = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)keyOI);
        return arrayOI;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Map map = this.moi.getMap(arguments[0].get());
        ArrayList array = new ArrayList();
        for (Object key : map.keySet()) {
            ArrayList<Object> kv = new ArrayList<Object>();
            kv.add(key);
            kv.add(map.get(key));
            array.add(kv);
        }
        return array;
    }

    public String getDisplayString(String[] children) {
        return "map_key_values( " + children[0] + " )";
    }
}

