/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="numeric_range", value="_FUNC_(a,b,c) - Generates a range of integers from a to b incremented by c or the elements of a map into multiple rows and columns ")
public class NumericRange
extends GenericUDTF {
    private IntObjectInspector startInspector = null;
    private IntObjectInspector endInspector = null;
    private IntObjectInspector incrementInspector = null;
    private final Object[] forwardListObj = new Object[1];

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length == 0 || argOIs.length > 3) {
            throw new UDFArgumentException("NumericRange takes 1 to 3 integer arguments");
        }
        for (ObjectInspector oi : argOIs) {
            if (oi.getCategory() == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentException("NumericRange takes 1 to 3 integer arguments");
        }
        if (argOIs.length == 1) {
            this.endInspector = (IntObjectInspector)argOIs[0];
        } else if (argOIs.length == 2) {
            this.startInspector = (IntObjectInspector)argOIs[0];
            this.endInspector = (IntObjectInspector)argOIs[1];
        } else if (argOIs.length == 3) {
            this.startInspector = (IntObjectInspector)argOIs[0];
            this.endInspector = (IntObjectInspector)argOIs[1];
            this.incrementInspector = (IntObjectInspector)argOIs[2];
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("n");
        ArrayList<JavaIntObjectInspector> fieldOIs = new ArrayList<JavaIntObjectInspector>();
        fieldOIs.add(PrimitiveObjectInspectorFactory.javaIntObjectInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        int start = 0;
        int nd = 0;
        int incr = 1;
        switch (args.length) {
            case 1: {
                nd = this.endInspector.get(args[0]);
                break;
            }
            case 2: {
                start = this.startInspector.get(args[0]);
                nd = this.endInspector.get(args[1]);
                break;
            }
            case 3: {
                start = this.startInspector.get(args[0]);
                nd = this.endInspector.get(args[1]);
                incr = this.incrementInspector.get(args[2]);
            }
        }
        for (int i = start; i < nd; i += incr) {
            this.forwardListObj[0] = new Integer(i);
            this.forward(this.forwardListObj);
        }
    }

    public void close() throws HiveException {
    }
}

