/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;

@Description(name="set_diff", value="_FUNC_(a,b) - Returns a list of those items in a, but not in b ")
public class SetDifferenceUDF
extends GenericUDF {
    private ObjectInspector.Category category;
    private ListObjectInspector list1Inspector;
    private ListObjectInspector list2Inspector;
    private MapObjectInspector map1Inspector;
    private MapObjectInspector map2Inspector;
    private PrimitiveObjectInspector prim1Inspector;
    private PrimitiveObjectInspector prim2Inspector;
    private StandardListObjectInspector stdListInspector;
    private StandardMapObjectInspector stdMapInspector;

    public List evaluate(List l1, List l2) {
        if (l1 == null) {
            return null;
        }
        HashSet<Object> negSet = new HashSet<Object>();
        if (l2 != null) {
            for (Object lObj : l2) {
                Object inspObj = this.prim2Inspector.getPrimitiveJavaObject(lObj);
                negSet.add(inspObj);
            }
        }
        List newList = (List)this.stdListInspector.create(0);
        for (Object obj : l1) {
            Object inspObj = this.prim1Inspector.getPrimitiveJavaObject(obj);
            if (negSet.contains(inspObj)) continue;
            newList.add(inspObj);
        }
        return newList;
    }

    public Map evaluate(Map m1, Map m2) {
        Object inspObj;
        Map newMap = (Map)this.stdMapInspector.create();
        if (m1 == null) {
            return null;
        }
        HashSet<Object> negSet = new HashSet<Object>();
        if (m2 != null) {
            for (Object mObj : m2.keySet()) {
                inspObj = this.prim2Inspector.getPrimitiveJavaObject(mObj);
                negSet.add(inspObj);
            }
        }
        if (m1.size() > 0) {
            for (Object k : m1.keySet()) {
                inspObj = this.prim1Inspector.getPrimitiveJavaObject(k);
                if (negSet.contains(inspObj)) continue;
                Object valObj = m1.get(k);
                Object stdVal = ObjectInspectorUtils.copyToStandardObject(valObj, (ObjectInspector)this.map1Inspector.getMapValueObjectInspector());
                newMap.put(inspObj, stdVal);
            }
        }
        return newMap;
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        if (this.category == ObjectInspector.Category.LIST) {
            List theList1 = this.list1Inspector.getList(args[0].get());
            List theList2 = this.list2Inspector.getList(args[1].get());
            List retList = this.evaluate(theList1, theList2);
            return retList;
        }
        if (this.category == ObjectInspector.Category.MAP) {
            Map theMap1 = this.map1Inspector.getMap(args[0].get());
            Map theMap2 = this.map2Inspector.getMap(args[1].get());
            Map retMap = this.evaluate(theMap1, theMap2);
            return retMap;
        }
        throw new HiveException(" Only maps or lists are supported ");
    }

    public String getDisplayString(String[] args) {
        StringBuilder sb = new StringBuilder("set_diff( ");
        for (int i = 0; i < args.length - 1; ++i) {
            sb.append(args[i]);
            sb.append(",");
        }
        sb.append(args[args.length - 1]);
        sb.append(")");
        return sb.toString();
    }

    public ObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length != 2) {
            throw new UDFArgumentException("Usage: set_diff takes 2  maps or lists, and returns the difference");
        }
        ObjectInspector first = args[0];
        ObjectInspector second = args[1];
        if (first.getCategory() == ObjectInspector.Category.LIST && second.getCategory() == ObjectInspector.Category.LIST) {
            this.category = first.getCategory();
            this.list1Inspector = (ListObjectInspector)first;
            this.list2Inspector = (ListObjectInspector)second;
            if (this.list1Inspector.getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE || this.list2Inspector.getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentException(" set_diff only takes maps or lists of primitives.");
            }
            this.prim1Inspector = (PrimitiveObjectInspector)this.list1Inspector.getListElementObjectInspector();
            this.prim2Inspector = (PrimitiveObjectInspector)this.list2Inspector.getListElementObjectInspector();
            if (this.prim1Inspector.getPrimitiveCategory() != this.prim2Inspector.getPrimitiveCategory()) {
                throw new UDFArgumentException(" set_diff takes only lists of the same primitive type.");
            }
            this.stdListInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.prim1Inspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA));
            return this.stdListInspector;
        }
        if (first.getCategory() == ObjectInspector.Category.MAP && second.getCategory() == ObjectInspector.Category.MAP) {
            this.category = first.getCategory();
            this.map1Inspector = (MapObjectInspector)first;
            this.map2Inspector = (MapObjectInspector)second;
            if (this.map1Inspector.getMapKeyObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE || this.map2Inspector.getMapKeyObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentException(" set_diff only takes maps or lists of primitives.");
            }
            this.prim1Inspector = (PrimitiveObjectInspector)this.map1Inspector.getMapKeyObjectInspector();
            this.prim2Inspector = (PrimitiveObjectInspector)this.map2Inspector.getMapKeyObjectInspector();
            if (this.prim1Inspector.getPrimitiveCategory() != this.prim2Inspector.getPrimitiveCategory()) {
                throw new UDFArgumentException(" set_diff takes only maps of the same primitive type.");
            }
            this.stdMapInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.prim1Inspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.map1Inspector.getMapValueObjectInspector()));
            return this.stdMapInspector;
        }
        throw new UDFArgumentException(" set_diff only takes maps or lists.");
    }
}

