/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;

public class TruncateArrayUDF
extends GenericUDF {
    private ListObjectInspector listInspector;
    private StandardListObjectInspector returnInspector;
    private IntObjectInspector intInspector;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        int numVals = this.intInspector.get(arg0[1].get());
        Object uninspListObj = arg0[0].get();
        int listSize = this.listInspector.getListLength(uninspListObj);
        Object truncatedListObj = this.returnInspector.create(numVals);
        for (int i = 0; i < numVals && i < listSize; ++i) {
            this.returnInspector.set(truncatedListObj, i, this.listInspector.getListElement(uninspListObj, i));
        }
        return truncatedListObj;
    }

    public String getDisplayString(String[] arg0) {
        return "truncate_array(" + arg0[0] + ", " + arg0[1] + " )";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        ObjectInspector first = arg0[0];
        if (first.getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException(" Expecting an array and an int as arguments ");
        }
        this.listInspector = (ListObjectInspector)first;
        ObjectInspector second = arg0[1];
        if (second.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector secondPrim = (PrimitiveObjectInspector)second;
            if (secondPrim.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) {
                throw new UDFArgumentException(" Expecting an array and an int as arguments ");
            }
        } else {
            throw new UDFArgumentException(" Expecting an array and an int as arguments ");
        }
        this.intInspector = (IntObjectInspector)second;
        this.returnInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.listInspector.getListElementObjectInspector());
        return this.returnInspector;
    }
}

