/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.collect;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="union", value="_FUNC_(x) - Returns a map which contains the union of an aggregation of maps ")
public class UnionUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "One argument is expected; either a map or an array.");
        }
        TypeInfo paramType = parameters[0];
        if (paramType.getCategory() == ObjectInspector.Category.MAP) {
            return new MapUnionUDAFEvaluator();
        }
        throw new UDFArgumentTypeException(0, " Only maps supported for now ");
    }

    public static class MapUnionUDAFEvaluator
    extends GenericUDAFEvaluator {
        private MapObjectInspector inputMapOI;
        private ObjectInspector inputKeyOI;
        private ObjectInspector inputValOI;
        private StandardMapObjectInspector moi;
        private StandardMapObjectInspector internalMergeOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1) {
                this.inputMapOI = (MapObjectInspector)parameters[0];
                this.inputKeyOI = this.inputMapOI.getMapKeyObjectInspector();
                this.inputValOI = this.inputMapOI.getMapValueObjectInspector();
                return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputKeyOI), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputValOI));
            }
            if (!(parameters[0] instanceof StandardMapObjectInspector)) {
                this.inputKeyOI = (PrimitiveObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)parameters[0]);
                this.inputValOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)parameters[0]);
                return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)this.inputKeyOI, (ObjectInspector)this.inputValOI);
            }
            this.internalMergeOI = (StandardMapObjectInspector)parameters[0];
            this.inputKeyOI = (PrimitiveObjectInspector)this.internalMergeOI.getMapKeyObjectInspector();
            this.inputValOI = this.internalMergeOI.getMapValueObjectInspector();
            this.moi = (StandardMapObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.internalMergeOI);
            return this.moi;
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            MapAggBuffer buff = new MapAggBuffer();
            this.reset(buff);
            return buff;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object mpObj = parameters[0];
            if (mpObj != null) {
                MapAggBuffer myagg = (MapAggBuffer)agg;
                Map mp = this.inputMapOI.getMap(mpObj);
                for (Object k : mp.keySet()) {
                    Object v = mp.get(k);
                    this.putIntoSet(k, v, myagg);
                }
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            MapAggBuffer myagg = (MapAggBuffer)agg;
            HashMap partialResult = (HashMap)this.internalMergeOI.getMap(partial);
            for (Object i : partialResult.keySet()) {
                this.putIntoSet(i, partialResult.get(i), myagg);
            }
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            MapAggBuffer arrayBuff = (MapAggBuffer)buff;
            arrayBuff.collectMap = new HashMap();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggBuffer myagg = (MapAggBuffer)agg;
            HashMap<Object, Object> ret = new HashMap<Object, Object>(myagg.collectMap);
            return ret;
        }

        private void putIntoSet(Object key, Object val, MapAggBuffer myagg) {
            Object keyCopy = ObjectInspectorUtils.copyToStandardObject((Object)key, (ObjectInspector)this.inputKeyOI);
            Object valCopy = ObjectInspectorUtils.copyToStandardObject((Object)val, (ObjectInspector)this.inputValOI);
            myagg.collectMap.put(keyCopy, valCopy);
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MapAggBuffer myagg = (MapAggBuffer)agg;
            HashMap<Object, Object> ret = new HashMap<Object, Object>(myagg.collectMap);
            return ret;
        }

        static class MapAggBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            HashMap<Object, Object> collectMap = new HashMap();

            MapAggBuffer() {
            }
        }
    }
}

