/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.date;

import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class AddDaysUDF
extends UDF {
    private static final Logger LOG = Logger.getLogger(AddDaysUDF.class);
    private static final DateTimeFormatter YYYYMMDD = DateTimeFormat.forPattern((String)"YYYYMMdd");

    public String evaluate(String dateStr, int numDays) {
        DateTime dt = YYYYMMDD.parseDateTime(dateStr);
        DateTime addedDt = dt.plusDays(numDays);
        String addedDtStr = YYYYMMDD.print((ReadableInstant)addedDt);
        return addedDtStr;
    }
}

