/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.date;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Description(name="date_range", value="_FUNC_(a,b,c) - Generates a range of integers from a to b incremented by c or the elements of a map into multiple rows and columns ")
public class DateRangeUDTF
extends GenericUDTF {
    private static DateTimeFormatter YYMMDD = DateTimeFormat.forPattern((String)"YYYYMMdd");
    private StringObjectInspector startInspector = null;
    private StringObjectInspector endInspector = null;
    private IntObjectInspector incrInspector = null;
    private final Object[] forwardListObj = new Object[2];

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length < 2 || argOIs.length > 3) {
            throw new UDFArgumentException("DateRange takes <startdate>, <enddate>, <optional increment>");
        }
        if (!(argOIs[0] instanceof StringObjectInspector)) {
            throw new UDFArgumentException("DateRange takes <startdate>, <enddate>, <optional increment>");
        }
        this.startInspector = (StringObjectInspector)argOIs[0];
        if (!(argOIs[1] instanceof StringObjectInspector)) {
            throw new UDFArgumentException("DateRange takes <startdate>, <enddate>, <optional increment>");
        }
        this.endInspector = (StringObjectInspector)argOIs[1];
        if (argOIs.length == 3) {
            if (!(argOIs[2] instanceof IntObjectInspector)) {
                throw new UDFArgumentException("DateRange takes <startdate>, <enddate>, <optional increment>");
            }
            this.incrInspector = (IntObjectInspector)argOIs[2];
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("date");
        fieldNames.add("index");
        ArrayList<Object> fieldOIs = new ArrayList<Object>();
        fieldOIs.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        fieldOIs.add(PrimitiveObjectInspectorFactory.javaIntObjectInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        String start = null;
        String end = null;
        int incr = 1;
        switch (args.length) {
            case 3: {
                incr = this.incrInspector.get(args[2]);
            }
            case 2: {
                start = this.startInspector.getPrimitiveJavaObject(args[0]);
                end = this.endInspector.getPrimitiveJavaObject(args[1]);
            }
        }
        try {
            DateTime startDt = YYMMDD.parseDateTime(start);
            DateTime endDt = YYMMDD.parseDateTime(end);
            int i = 0;
            DateTime dt = startDt;
            while (dt.isBefore((ReadableInstant)endDt) || dt.isEqual((ReadableInstant)endDt)) {
                this.forwardListObj[0] = YYMMDD.print((ReadableInstant)dt);
                this.forwardListObj[1] = new Integer(i);
                this.forward(this.forwardListObj);
                dt = dt.plusDays(incr);
                ++i;
            }
        }
        catch (IllegalArgumentException badFormat) {
            throw new HiveException("Unable to parse dates; start = " + start + " ; end = " + end);
        }
    }

    public void close() throws HiveException {
    }
}

