/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.date;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Description(name="day_diff", value=" The difference in days of two YYYYMMDD dates")
public class DayDiffUDF
extends UDF {
    private static final Logger LOG = Logger.getLogger(DayDiffUDF.class);
    private static final DateTimeFormatter YYYYMMDD = DateTimeFormat.forPattern((String)"YYYYMMdd");

    public Integer evaluate(String date1Str, String date2Str) {
        DateTime dt1 = YYYYMMDD.parseDateTime(date1Str);
        DateTime dt2 = YYYYMMDD.parseDateTime(date2Str);
        int dayDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
        return dayDiff;
    }
}

