/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.dcache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

@UDFType(deterministic=false)
public class DistributedMapUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(DistributedMapUDF.class);
    private static HashMap<String, HashMap<Object, Object>> localMapMap = new HashMap();
    private StringObjectInspector fileNameInspector;
    private PrimitiveObjectInspector keyInspector;
    private TypeInfo keyType;
    private TypeInfo valType;
    private LazySimpleSerDe serde;

    private LazySimpleSerDe getLineSerde() throws SerDeException {
        if (this.serde == null) {
            Logger.getLogger(LazySimpleSerDe.class).setLevel(Level.DEBUG);
            this.serde = new LazySimpleSerDe();
            Configuration job = new Configuration();
            Properties tbl = new Properties();
            tbl.setProperty("columns", "key,value");
            tbl.setProperty("columns.types", this.keyType.getTypeName() + "," + this.valType.getTypeName());
            this.serde.initialize(job, tbl);
        }
        return this.serde;
    }

    private void addValues(HashMap<Object, Object> map, String mapFilename) throws IOException, SerDeException {
        if (!mapFilename.endsWith("crc")) {
            File mapFile = new File(mapFilename);
            if (mapFile.isDirectory()) {
                String[] subFiles;
                for (String subFile : subFiles = mapFile.list()) {
                    LOG.info((Object)("Checking recursively " + subFile));
                    this.addValues(map, mapFilename + "/" + subFile);
                }
            } else {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(mapFile)));
                LazySimpleSerDe lazy = this.getLineSerde();
                StructObjectInspector lineInsp = (StructObjectInspector)lazy.getObjectInspector();
                StructField keyRef = lineInsp.getStructFieldRef("key");
                StructField valueRef = lineInsp.getStructFieldRef("value");
                while ((line = reader.readLine()) != null) {
                    Text lineText = new Text(line);
                    Object lineObj = lazy.deserialize((Writable)lineText);
                    List objList = lineInsp.getStructFieldsDataAsList(lineObj);
                    Object key = ((PrimitiveObjectInspector)keyRef.getFieldObjectInspector()).getPrimitiveJavaObject(objList.get(0));
                    Object val = ((PrimitiveObjectInspector)valueRef.getFieldObjectInspector()).getPrimitiveJavaObject(objList.get(1));
                    map.put(key, val);
                }
            }
        } else {
            LOG.info((Object)(" Ignoring CRC file " + mapFilename));
        }
    }

    private Map<Object, Object> getLocalMap(String mapFileName) {
        HashMap<Object, Object> map = localMapMap.get(mapFileName);
        if (map == null) {
            try {
                String[] files;
                File localDir = new File(".");
                for (String file : files = localDir.list()) {
                    LOG.info((Object)(" In current dir is " + file));
                    File checkFile = new File(file);
                    if (!checkFile.isDirectory()) continue;
                    LOG.info((Object)(" FILE " + file + " is a directory"));
                }
                map = new HashMap();
                this.addValues(map, mapFileName);
                localMapMap.put(mapFileName, map);
            }
            catch (IOException ioExc) {
                ioExc.printStackTrace();
                throw new RuntimeException(ioExc);
            }
            catch (SerDeException serdeExc) {
                throw new RuntimeException(serdeExc);
            }
        }
        return map;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        if (this.keyInspector != null) {
            Object key = this.keyInspector.getPrimitiveJavaObject(arg0[0].get());
            String mapFileName = this.fileNameInspector.getPrimitiveJavaObject(arg0[1].get());
            Map<Object, Object> map = this.getLocalMap(mapFileName);
            return map.get(key);
        }
        Object mapFNameObj = arg0.length == 1 ? arg0[0].get() : arg0[1].get();
        String mapFileName = this.fileNameInspector.getPrimitiveJavaObject(mapFNameObj);
        Map<Object, Object> map = this.getLocalMap(mapFileName);
        return map;
    }

    public String getDisplayString(String[] arg0) {
        return "distributed_map()";
    }

    public String usage(String err) {
        return " Distributed Map -- Case  " + err;
    }

    private MapObjectInspector getMapType(String typeStr) throws UDFArgumentException, IllegalArgumentException {
        try {
            TypeInfo hiveType = TypeInfoUtils.getTypeInfoFromTypeString((String)typeStr);
            if (hiveType.getCategory() != ObjectInspector.Category.MAP) {
                throw new UDFArgumentException(this.usage("Type is not map"));
            }
            MapObjectInspector mapInsp = (MapObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)hiveType);
            if (mapInsp.getMapKeyObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentException(this.usage("Key is not primitive"));
            }
            return mapInsp;
        }
        catch (IllegalArgumentException badTypeStr) {
            throw new UDFArgumentException(this.usage("String is not type"));
        }
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length == 0 || arg0.length > 3) {
            throw new UDFArgumentException(this.usage("Between 1 and 3 arguments"));
        }
        switch (arg0.length) {
            case 1: {
                if (!(arg0[0] instanceof ConstantObjectInspector) || !(arg0[0] instanceof StringObjectInspector)) {
                    throw new UDFArgumentException(this.usage(" 1 arguments is always name of directory"));
                }
                this.fileNameInspector = (StringObjectInspector)arg0[0];
                this.keyType = TypeInfoFactory.stringTypeInfo;
                this.valType = TypeInfoFactory.doubleTypeInfo;
                return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector);
            }
            case 2: {
                if (!(arg0[1] instanceof ConstantObjectInspector && arg0[1] instanceof StringObjectInspector && arg0[0] instanceof PrimitiveObjectInspector)) {
                    throw new UDFArgumentException(this.usage("2 arguments is eiter key and filename, or a filename and maptype"));
                }
                ConstantObjectInspector mapType = (ConstantObjectInspector)arg0[1];
                String typeStr = mapType.getWritableConstantValue().toString();
                try {
                    MapObjectInspector mapInsp = this.getMapType(typeStr);
                    this.keyType = TypeInfoFactory.getPrimitiveTypeInfo((String)mapInsp.getMapKeyObjectInspector().getTypeName());
                    this.valType = TypeInfoFactory.getPrimitiveTypeInfo((String)mapInsp.getMapValueObjectInspector().getTypeName());
                    this.fileNameInspector = (StringObjectInspector)arg0[0];
                    return ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)mapInsp);
                }
                catch (UDFArgumentException checkMapType) {
                    this.keyInspector = (PrimitiveObjectInspector)arg0[0];
                    this.keyType = TypeInfoFactory.getPrimitiveTypeInfo((String)this.keyInspector.getTypeName());
                    this.valType = TypeInfoFactory.doubleTypeInfo;
                    this.fileNameInspector = (StringObjectInspector)arg0[1];
                    return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
                }
            }
            case 3: {
                if (!(arg0[1] instanceof ConstantObjectInspector && arg0[1] instanceof StringObjectInspector && arg0[2] instanceof ConstantObjectInspector && arg0[2] instanceof StringObjectInspector && arg0[0] instanceof PrimitiveObjectInspector)) {
                    throw new UDFArgumentException(this.usage("3 arguments are key,filename and maptype"));
                }
                this.fileNameInspector = (StringObjectInspector)arg0[1];
                ConstantObjectInspector mapType3 = (ConstantObjectInspector)arg0[2];
                String typeStr3 = mapType3.getWritableConstantValue().toString();
                MapObjectInspector mapInspect = this.getMapType(typeStr3);
                this.keyInspector = (PrimitiveObjectInspector)arg0[0];
                if (this.keyInspector.getPrimitiveCategory() != ((PrimitiveObjectInspector)mapInspect.getMapKeyObjectInspector()).getPrimitiveCategory()) {
                    throw new UDFArgumentException(this.usage("Key must be primitive"));
                }
                this.keyType = TypeInfoFactory.getPrimitiveTypeInfo((String)this.keyInspector.getTypeName());
                ObjectInspector valInspector = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)mapInspect.getMapValueObjectInspector());
                this.valType = TypeInfoFactory.getPrimitiveTypeInfo((String)valInspector.getTypeName());
                return valInspector;
            }
        }
        return null;
    }
}

