/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.hll;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.log4j.Logger;

@Description(name="combine_hyperloglog", value="_FUNC_(x) - Combined two  HyperLogLog++ binary blobs. ")
public class CombineHyperLogLogUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(CombineHyperLogLogUDF.class);
    private BinaryObjectInspector binary1Inspector;
    private BinaryObjectInspector binary2Inspector;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        try {
            Object blobObj1 = arg0[0].get();
            Object blobObj2 = arg0[1].get();
            byte[] bref1 = this.binary1Inspector.getPrimitiveJavaObject(blobObj1);
            byte[] bref2 = this.binary2Inspector.getPrimitiveJavaObject(blobObj2);
            if (bref1 != null && bref2 != null) {
                HyperLogLogPlus hll1 = HyperLogLogPlus.Builder.build((byte[])bref1);
                HyperLogLogPlus hll2 = HyperLogLogPlus.Builder.build((byte[])bref2);
                ICardinality merged = hll1.merge(new ICardinality[]{hll2});
                return merged.getBytes();
            }
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Error", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public String getDisplayString(String[] arg0) {
        StringBuilder sb = new StringBuilder("combine_hyperloglog( ");
        for (int i = 0; i < arg0.length - 1; ++i) {
            sb.append(arg0[i]);
            sb.append(" , ");
        }
        sb.append(arg0[arg0.length - 1]);
        sb.append(" )");
        return sb.toString();
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length != 2) {
            throw new UDFArgumentException("combine_hyperloglog takes a pair of binary objects which were created with the hyperloglog UDAF");
        }
        if (arg0[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("combine_hyperloglog takes a pair of binary objects which were created with the hyperloglog UDAF");
        }
        PrimitiveObjectInspector primInsp = (PrimitiveObjectInspector)arg0[0];
        if (primInsp.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.BINARY) {
            throw new UDFArgumentException("hll_est_cardinality takes a binary object which was created with the hyperloglog UDAF");
        }
        this.binary1Inspector = (BinaryObjectInspector)arg0[0];
        this.binary2Inspector = (BinaryObjectInspector)arg0[1];
        return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
    }
}

