/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.hll;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.log4j.Logger;

@Description(name="hll_est_cardinality", value="_FUNC_(x) - Estimate reach from a  HyperLogLog++. ")
public class EstimateCardinalityUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(EstimateCardinalityUDF.class);
    private BinaryObjectInspector binaryInspector;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        try {
            Object blobObj = arg0[0].get();
            byte[] bref = this.binaryInspector.getPrimitiveJavaObject(blobObj);
            if (bref == null) {
                return null;
            }
            HyperLogLogPlus hll = HyperLogLogPlus.Builder.build((byte[])bref);
            return hll.cardinality();
        }
        catch (Exception e) {
            LOG.error((Object)"Error", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public String getDisplayString(String[] arg0) {
        StringBuilder sb = new StringBuilder("hll_est_cardinality( ");
        for (int i = 0; i < arg0.length - 1; ++i) {
            sb.append(arg0[i]);
            sb.append(" , ");
        }
        sb.append(arg0[arg0.length - 1]);
        sb.append(" )");
        return sb.toString();
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length != 1) {
            throw new UDFArgumentException("hll_est_cardinality takes a binary object which was created with the hyperloglog UDAF");
        }
        if (arg0[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("hll_est_cardinality takes a binary object which was created with the hyperloglog UDAF");
        }
        PrimitiveObjectInspector primInsp = (PrimitiveObjectInspector)arg0[0];
        if (primInsp.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.BINARY) {
            throw new UDFArgumentException("hll_est_cardinality takes a binary object which was created with the hyperloglog UDAF");
        }
        this.binaryInspector = (BinaryObjectInspector)primInsp;
        return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
    }
}

