/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.hll;

import brickhouse.udf.hll.HLLBuffer;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.log4j.Logger;

@Description(name="hyperloglog", value="_FUNC_(x) - Constructs a HyperLogLog to estimate reach for large values  ")
public class HyperLogLogUDAF
extends AbstractGenericUDAFResolver {
    private static final Logger LOG = Logger.getLogger(HyperLogLogUDAF.class);
    static final int PRECISION = 6;

    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        return new HyperLogLogUDAFEvaluator();
    }

    public static class HyperLogLogUDAFEvaluator
    extends GenericUDAFEvaluator {
        private StringObjectInspector inputStrOI;
        private BinaryObjectInspector partialBufferOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputStrOI = (StringObjectInspector)parameters[0];
            } else {
                this.partialBufferOI = (BinaryObjectInspector)parameters[0];
            }
            if (m == GenericUDAFEvaluator.Mode.FINAL || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
            }
            return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            HLLBuffer buff = new HLLBuffer();
            buff.init(6);
            return buff;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object strObj = parameters[0];
            if (strObj != null) {
                String str = this.inputStrOI.getPrimitiveJavaObject(strObj);
                HLLBuffer myagg = (HLLBuffer)agg;
                myagg.addItem(str);
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            try {
                HLLBuffer myagg = (HLLBuffer)agg;
                byte[] partialBuffer = this.partialBufferOI.getPrimitiveJavaObject(partial);
                myagg.merge(partialBuffer);
            }
            catch (Exception e) {
                throw new HiveException((Throwable)e);
            }
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            HLLBuffer hllBuff = (HLLBuffer)buff;
            hllBuff.reset();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            try {
                HLLBuffer myagg = (HLLBuffer)agg;
                return myagg.getPartial();
            }
            catch (Exception e) {
                throw new HiveException((Throwable)e);
            }
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }
    }
}

