/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.hll;

import brickhouse.udf.hll.HLLBuffer;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.log4j.Logger;

@Description(name="union_hyperloglog", value="_FUNC_(x) - Merges multiple hyperloglogs together. ")
public class UnionHyperLogLogUDAF
extends AbstractGenericUDAFResolver {
    private static final Logger LOG = Logger.getLogger(UnionHyperLogLogUDAF.class);

    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        return new MergeHyperLogLogUDAFEvaluator();
    }

    public static class MergeHyperLogLogUDAFEvaluator
    extends GenericUDAFEvaluator {
        private BinaryObjectInspector inputBinaryOI;
        private BinaryObjectInspector partialBinaryOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            LOG.info((Object)(" MergeHyperLogLogUDAF.init() - Mode= " + m.name()));
            for (int i = 0; i < parameters.length; ++i) {
                LOG.info((Object)(" ObjectInspector[ " + i + " ] = " + parameters[0]));
            }
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputBinaryOI = (BinaryObjectInspector)parameters[0];
            } else {
                this.partialBinaryOI = (BinaryObjectInspector)parameters[0];
            }
            if (m == GenericUDAFEvaluator.Mode.FINAL || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
            }
            return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            HLLBuffer buff = new HLLBuffer();
            buff.init(6);
            return buff;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            try {
                Object blobObj = parameters[0];
                if (blobObj != null) {
                    byte[] bref = this.inputBinaryOI.getPrimitiveJavaObject(blobObj);
                    HLLBuffer hllBuff = (HLLBuffer)agg;
                    if (bref != null) {
                        hllBuff.merge(bref);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error", (Throwable)e);
                throw new HiveException((Throwable)e);
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            try {
                HLLBuffer myagg = (HLLBuffer)agg;
                byte[] bref = this.partialBinaryOI.getPrimitiveJavaObject(partial);
                myagg.merge(bref);
            }
            catch (Exception e) {
                LOG.error((Object)"Error", (Throwable)e);
                throw new HiveException((Throwable)e);
            }
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            HLLBuffer hllBuff = (HLLBuffer)buff;
            hllBuff.reset();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            try {
                HLLBuffer myagg = (HLLBuffer)agg;
                return myagg.getPartial();
            }
            catch (Exception e) {
                LOG.error((Object)"Error", (Throwable)e);
                throw new HiveException((Throwable)e);
            }
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }
    }
}

