/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.json;

import brickhouse.udf.json.InspectorHandle;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;

@Description(name="from_json", value="_FUNC_(json,template,convert_flag) - Returns an arbitrary Hive Structure given a JSON string, and an example template object.")
public class FromJsonUDF
extends GenericUDF {
    private StringObjectInspector jsonInspector;
    private InspectorHandle inspHandle;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        try {
            String jsonString = this.jsonInspector.getPrimitiveJavaObject(arg0[0].get());
            if (jsonString == null) {
                return null;
            }
            ObjectMapper jacksonParser = new ObjectMapper();
            JsonNode jsonNode = jacksonParser.readTree(jsonString);
            return this.inspHandle.parseJson(jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new HiveException((Throwable)e);
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public String getDisplayString(String[] arg0) {
        return "from_json( \"" + arg0[0] + "\" , \"" + arg0[1] + "\" )";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length != 2) {
            throw new UDFArgumentException("from_json expects a JSON string and a template object");
        }
        if (arg0[0].getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)arg0[0]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new UDFArgumentException("from_json expects a JSON string and a template object");
        }
        this.jsonInspector = (StringObjectInspector)arg0[0];
        if (arg0[1].getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveObjectInspector)arg0[1]).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            if (!(arg0[1] instanceof ConstantObjectInspector)) {
                throw new UDFArgumentException("typeinfo string must be constant");
            }
            ConstantObjectInspector typeInsp = (ConstantObjectInspector)arg0[1];
            String typeStr = typeInsp.getWritableConstantValue().toString();
            this.inspHandle = InspectorHandle.InspectorHandleFactory.GenerateInspectorHandleFromTypeInfo(typeStr);
        } else {
            this.inspHandle = InspectorHandle.InspectorHandleFactory.GenerateInspectorHandle(arg0[1]);
        }
        return this.inspHandle.getReturnType();
    }

    public static String ToCamelCase(String underscore) {
        StringBuilder sb = new StringBuilder();
        String[] splArr = underscore.toLowerCase().split("_");
        sb.append(splArr[0]);
        for (int i = 1; i < splArr.length; ++i) {
            String word = splArr[i];
            char firstChar = word.charAt(0);
            if (firstChar >= 'a' && firstChar <= 'z') {
                sb.append((char)(word.charAt(0) + 65 - 97));
                sb.append(word.substring(1));
                continue;
            }
            sb.append(word);
        }
        return sb.toString();
    }

    public static String FromCamelCase(String camel) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camel.length(); ++i) {
            char ch = camel.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                sb.append('_');
                sb.append((char)(ch - 65 + 97));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

