/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.json;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.codehaus.jackson.JsonNode;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public interface InspectorHandle {
    public Object parseJson(JsonNode var1);

    public ObjectInspector getReturnType();

    public static class PrimitiveHandle
    implements InspectorHandle {
        private PrimitiveObjectInspector.PrimitiveCategory category;
        private DateTimeFormatter isoFormatter = ISODateTimeFormat.dateTimeNoMillis();

        public PrimitiveHandle(PrimitiveObjectInspector insp) throws UDFArgumentException {
            this.category = insp.getPrimitiveCategory();
        }

        @Override
        public Object parseJson(JsonNode jsonNode) {
            if (jsonNode == null || jsonNode.isNull()) {
                return null;
            }
            switch (this.category) {
                case STRING: {
                    return jsonNode.getTextValue();
                }
                case LONG: {
                    return jsonNode.getLongValue();
                }
                case SHORT: {
                    return (short)jsonNode.getIntValue();
                }
                case BYTE: {
                    return (byte)jsonNode.getIntValue();
                }
                case BINARY: {
                    try {
                        return jsonNode.getBinaryValue();
                    }
                    catch (IOException ioExc) {
                        return jsonNode.toString();
                    }
                }
                case INT: {
                    return jsonNode.getIntValue();
                }
                case FLOAT: {
                    return new Float(jsonNode.getDoubleValue());
                }
                case DOUBLE: {
                    return jsonNode.getDoubleValue();
                }
                case BOOLEAN: {
                    return jsonNode.getBooleanValue();
                }
                case TIMESTAMP: {
                    long time = this.isoFormatter.parseMillis(jsonNode.getTextValue());
                    return new Timestamp(time);
                }
            }
            return null;
        }

        @Override
        public ObjectInspector getReturnType() {
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)this.category);
        }
    }

    public static class ListHandle
    implements InspectorHandle {
        private StandardListObjectInspector retInspector;
        private InspectorHandle elemHandle;

        public ListHandle(ListObjectInspector insp) throws UDFArgumentException {
            this.elemHandle = InspectorHandleFactory.GenerateInspectorHandle(insp.getListElementObjectInspector());
        }

        @Override
        public Object parseJson(JsonNode jsonNode) {
            if (jsonNode.isNull()) {
                return null;
            }
            List newList = (List)this.retInspector.create(0);
            Iterator listNodes = jsonNode.getElements();
            while (listNodes.hasNext()) {
                JsonNode elemNode = (JsonNode)listNodes.next();
                if (elemNode != null) {
                    Object elemObj = this.elemHandle.parseJson(elemNode);
                    newList.add(elemObj);
                    continue;
                }
                newList.add(null);
            }
            return newList;
        }

        @Override
        public ObjectInspector getReturnType() {
            this.retInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.elemHandle.getReturnType());
            return this.retInspector;
        }
    }

    public static class MapHandle
    implements InspectorHandle {
        private InspectorHandle mapValHandle;
        private StandardMapObjectInspector retInspector;

        public MapHandle(MapObjectInspector insp) throws UDFArgumentException {
            if (!(insp.getMapKeyObjectInspector() instanceof StringObjectInspector)) {
                throw new RuntimeException(" JSON maps can only have strings as keys");
            }
            this.mapValHandle = InspectorHandleFactory.GenerateInspectorHandle(insp.getMapValueObjectInspector());
        }

        @Override
        public Object parseJson(JsonNode jsonNode) {
            if (jsonNode.isNull()) {
                return null;
            }
            Map newMap = (Map)this.retInspector.create();
            Iterator keys = jsonNode.getFieldNames();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JsonNode valNode = jsonNode.get(key);
                Object val = this.mapValHandle.parseJson(valNode);
                newMap.put(key, val);
            }
            return newMap;
        }

        @Override
        public ObjectInspector getReturnType() {
            this.retInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)this.mapValHandle.getReturnType());
            return this.retInspector;
        }
    }

    public static class StructHandle
    implements InspectorHandle {
        private List<String> fieldNames = new ArrayList<String>();
        private List<InspectorHandle> handleList = new ArrayList<InspectorHandle>();

        public StructHandle(StructObjectInspector structInspector) throws UDFArgumentException {
            List refs = structInspector.getAllStructFieldRefs();
            for (StructField ref : refs) {
                this.fieldNames.add(ref.getFieldName());
                InspectorHandle fieldHandle = InspectorHandleFactory.GenerateInspectorHandle(ref.getFieldObjectInspector());
                this.handleList.add(fieldHandle);
            }
        }

        @Override
        public Object parseJson(JsonNode jsonNode) {
            if (jsonNode.isNull()) {
                return null;
            }
            ArrayList<Object> valList = new ArrayList<Object>();
            for (int i = 0; i < this.fieldNames.size(); ++i) {
                String key = this.fieldNames.get(i);
                JsonNode valNode = jsonNode.get(key);
                InspectorHandle valHandle = this.handleList.get(i);
                Object valObj = valHandle.parseJson(valNode);
                valList.add(valObj);
            }
            return valList;
        }

        @Override
        public ObjectInspector getReturnType() {
            ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>();
            for (InspectorHandle fieldHandle : this.handleList) {
                structFieldObjectInspectors.add(fieldHandle.getReturnType());
            }
            return ObjectInspectorFactory.getStandardStructObjectInspector(this.fieldNames, structFieldObjectInspectors);
        }
    }

    public static final class InspectorHandleFactory {
        public static InspectorHandle GenerateInspectorHandle(ObjectInspector insp) throws UDFArgumentException {
            ObjectInspector.Category cat = insp.getCategory();
            switch (cat) {
                case LIST: {
                    return new ListHandle((ListObjectInspector)insp);
                }
                case MAP: {
                    return new MapHandle((MapObjectInspector)insp);
                }
                case STRUCT: {
                    return new StructHandle((StructObjectInspector)insp);
                }
                case PRIMITIVE: {
                    return new PrimitiveHandle((PrimitiveObjectInspector)insp);
                }
            }
            return null;
        }

        public static InspectorHandle GenerateInspectorHandleFromTypeInfo(String typeStr) throws UDFArgumentException {
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeStr);
            ObjectInspector objInsp = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
            return InspectorHandleFactory.GenerateInspectorHandle(objInsp);
        }
    }
}

