/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.json;

import brickhouse.udf.json.InspectorHandle;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;

@Description(name="json_map", value="_FUNC_(json) - Returns a map of key-value pairs from a JSON string")
public class JsonMapUDF
extends GenericUDF {
    private StringObjectInspector stringInspector;
    private InspectorHandle inspHandle;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1 && arguments.length != 2) {
            throw new UDFArgumentException("Usage : json_map( jsonstring, optional typestring ) ");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) || ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new UDFArgumentException("Usage : json_map( jsonstring, optional typestring) ");
        }
        this.stringInspector = (StringObjectInspector)arguments[0];
        if (arguments.length > 1) {
            if (!arguments[1].getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && ((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                throw new UDFArgumentException("Usage : json_map( jsonstring, optional typestring) ");
            }
            if (!(arguments[1] instanceof ConstantObjectInspector)) {
                throw new UDFArgumentException("json_map( jsonstring, typestring ) : typestring must be a constant");
            }
            ConstantObjectInspector constInsp = (ConstantObjectInspector)arguments[1];
            String typeStr = ((Text)constInsp.getWritableConstantValue()).toString();
            String[] types = typeStr.split(",");
            if (types.length != 2) {
                throw new UDFArgumentException(" typestring must be of the form <keytype>,<valuetype>");
            }
            TypeInfo keyType = TypeInfoUtils.getTypeInfoFromTypeString((String)types[0]);
            TypeInfo valType = TypeInfoUtils.getTypeInfoFromTypeString((String)types[1]);
            ObjectInspector keyInsp = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)keyType);
            ObjectInspector valInsp = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)valType);
            StandardMapObjectInspector mapInsp = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyInsp, (ObjectInspector)valInsp);
            this.inspHandle = InspectorHandle.InspectorHandleFactory.GenerateInspectorHandle((ObjectInspector)mapInsp);
            return this.inspHandle.getReturnType();
        }
        JavaStringObjectInspector keyInsp = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        JavaDoubleObjectInspector valueInsp = PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        StandardMapObjectInspector mapInsp = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyInsp, (ObjectInspector)valueInsp);
        this.inspHandle = InspectorHandle.InspectorHandleFactory.GenerateInspectorHandle((ObjectInspector)mapInsp);
        return this.inspHandle.getReturnType();
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        try {
            String jsonString = this.stringInspector.getPrimitiveJavaObject(arguments[0].get());
            ObjectMapper om = new ObjectMapper();
            JsonNode jsonNode = om.readTree(jsonString);
            return this.inspHandle.parseJson(jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new HiveException((Throwable)e);
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public String getDisplayString(String[] children) {
        return "json_map( " + children[0] + " )";
    }
}

