/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.json;

import brickhouse.udf.json.InspectorHandle;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;

@Description(name="json_split", value="_FUNC_(json) - Returns a array of JSON strings from a JSON Array")
public class JsonSplitUDF
extends GenericUDF {
    private StringObjectInspector stringInspector;
    private InspectorHandle inspHandle;

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        try {
            String jsonString = this.stringInspector.getPrimitiveJavaObject(arguments[0].get());
            ObjectMapper om = new ObjectMapper();
            JsonNode jsonNode = om.readTree(jsonString);
            return this.inspHandle.parseJson(jsonNode);
        }
        catch (JsonProcessingException jsonProc) {
            throw new HiveException((Throwable)jsonProc);
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public String getDisplayString(String[] arg0) {
        return "json_split(" + arg0[0] + ")";
    }

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1 && arguments.length != 2) {
            throw new UDFArgumentException("Usage : json_split( jsonstring, optional typestring) ");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) || ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new UDFArgumentException("Usage : json_split( jsonstring, optional typestring) ");
        }
        this.stringInspector = (StringObjectInspector)arguments[0];
        if (arguments.length > 1) {
            if (!arguments[1].getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) || ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                throw new UDFArgumentException("Usage : json_split( jsonstring, optional typestring) ");
            }
            if (!(arguments[1] instanceof ConstantObjectInspector)) {
                throw new UDFArgumentException("Usage : json_split( jsonstring, typestring) : typestring must be constant");
            }
            ConstantObjectInspector typeInsp = (ConstantObjectInspector)arguments[1];
            String typeString = ((Text)typeInsp.getWritableConstantValue()).toString();
            TypeInfo valType = TypeInfoUtils.getTypeInfoFromTypeString((String)typeString);
            ObjectInspector valInsp = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)valType);
            StandardListObjectInspector setInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)valInsp);
            this.inspHandle = InspectorHandle.InspectorHandleFactory.GenerateInspectorHandle((ObjectInspector)setInspector);
            return this.inspHandle.getReturnType();
        }
        JavaStringObjectInspector valInspector = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        StandardListObjectInspector setInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)valInspector);
        this.inspHandle = InspectorHandle.InspectorHandleFactory.GenerateInspectorHandle((ObjectInspector)setInspector);
        return this.inspHandle.getReturnType();
    }
}

