/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.json;

import brickhouse.udf.json.FromJsonUDF;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantBooleanObjectInspector;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Description(name="to_json", value="_FUNC_(struct, convert_to_camel_case) - Returns a JSON string from an arbitrary Hive structure.")
public class ToJsonUDF
extends GenericUDF {
    private InspectorHandle inspHandle;
    private Boolean convertFlag = Boolean.FALSE;
    private JsonFactory jsonFactory;

    private InspectorHandle GenerateInspectorHandle(ObjectInspector insp) throws UDFArgumentException {
        ObjectInspector.Category cat = insp.getCategory();
        if (cat == ObjectInspector.Category.MAP) {
            return new MapInspectorHandle((MapObjectInspector)insp);
        }
        if (cat == ObjectInspector.Category.LIST) {
            return new ArrayInspectorHandle((ListObjectInspector)insp);
        }
        if (cat == ObjectInspector.Category.STRUCT) {
            return new StructInspectorHandle((StructObjectInspector)insp);
        }
        if (cat == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector primInsp = (PrimitiveObjectInspector)insp;
            PrimitiveObjectInspector.PrimitiveCategory primCat = primInsp.getPrimitiveCategory();
            if (primCat == PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                return new StringInspectorHandle((StringObjectInspector)primInsp);
            }
            if (primCat == PrimitiveObjectInspector.PrimitiveCategory.INT) {
                return new IntInspectorHandle((IntObjectInspector)primInsp);
            }
            if (primCat == PrimitiveObjectInspector.PrimitiveCategory.LONG) {
                return new LongInspectorHandle((LongObjectInspector)primInsp);
            }
            if (primCat == PrimitiveObjectInspector.PrimitiveCategory.SHORT) {
                return new ShortInspectorHandle((ShortObjectInspector)primInsp);
            }
            if (primCat == PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN) {
                return new BooleanInspectorHandle((BooleanObjectInspector)primInsp);
            }
            if (primCat == PrimitiveObjectInspector.PrimitiveCategory.FLOAT) {
                return new FloatInspectorHandle((FloatObjectInspector)primInsp);
            }
            if (primCat == PrimitiveObjectInspector.PrimitiveCategory.DOUBLE) {
                return new DoubleInspectorHandle((DoubleObjectInspector)primInsp);
            }
            if (primCat == PrimitiveObjectInspector.PrimitiveCategory.BYTE) {
                return new ByteInspectorHandle((ByteObjectInspector)primInsp);
            }
            if (primCat == PrimitiveObjectInspector.PrimitiveCategory.BINARY) {
                return new BinaryInspectorHandle((BinaryObjectInspector)primInsp);
            }
        }
        throw new UDFArgumentException("Don't know how to handle object inspector " + insp);
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator gen = this.jsonFactory.createJsonGenerator((Writer)writer);
            this.inspHandle.generateJson(gen, args[0].get());
            gen.close();
            writer.close();
            return writer.toString();
        }
        catch (IOException io) {
            throw new HiveException((Throwable)io);
        }
    }

    public String getDisplayString(String[] args) {
        return "to_json(" + args[0] + ")";
    }

    public ObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length != 1 && args.length != 2) {
            throw new UDFArgumentException(" ToJson takes an object as an argument, and an optional to_camel_case flag");
        }
        ObjectInspector oi = args[0];
        this.inspHandle = this.GenerateInspectorHandle(oi);
        if (args.length == 2) {
            ObjectInspector flagInsp = args[1];
            if (flagInsp.getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)flagInsp).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN || !(flagInsp instanceof ConstantObjectInspector)) {
                throw new UDFArgumentException(" ToJson takes an object as an argument, and an optional to_camel_case flag");
            }
            WritableConstantBooleanObjectInspector constInsp = (WritableConstantBooleanObjectInspector)flagInsp;
            this.convertFlag = constInsp.getWritableConstantValue().get();
        }
        this.jsonFactory = new JsonFactory();
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }

    private class TimestampInspectorHandle
    implements InspectorHandle {
        private TimestampObjectInspector timestampInspector;
        private DateTimeFormatter isoFormatter = ISODateTimeFormat.dateTimeNoMillis();

        public TimestampInspectorHandle(TimestampObjectInspector insp) {
            this.timestampInspector = insp;
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                Timestamp timestamp = this.timestampInspector.getPrimitiveJavaObject(obj);
                String timeStr = this.isoFormatter.print(timestamp.getTime());
                gen.writeString(timeStr);
            }
        }
    }

    private class BinaryInspectorHandle
    implements InspectorHandle {
        private BinaryObjectInspector binaryInspector;

        public BinaryInspectorHandle(BinaryObjectInspector insp) {
            this.binaryInspector = insp;
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                byte[] bytes = this.binaryInspector.getPrimitiveJavaObject(obj);
                gen.writeBinary(bytes);
            }
        }
    }

    private class BooleanInspectorHandle
    implements InspectorHandle {
        private BooleanObjectInspector boolInspector;

        public BooleanInspectorHandle(BooleanObjectInspector insp) {
            this.boolInspector = insp;
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                boolean tf = this.boolInspector.get(obj);
                gen.writeBoolean(tf);
            }
        }
    }

    private class FloatInspectorHandle
    implements InspectorHandle {
        private FloatObjectInspector floatInspector;

        public FloatInspectorHandle(FloatObjectInspector insp) {
            this.floatInspector = insp;
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                float num = this.floatInspector.get(obj);
                gen.writeNumber(num);
            }
        }
    }

    private class ByteInspectorHandle
    implements InspectorHandle {
        private ByteObjectInspector byteInspector;

        public ByteInspectorHandle(ByteObjectInspector insp) {
            this.byteInspector = insp;
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                byte num = this.byteInspector.get(obj);
                gen.writeNumber((int)num);
            }
        }
    }

    private class ShortInspectorHandle
    implements InspectorHandle {
        private ShortObjectInspector shortInspector;

        public ShortInspectorHandle(ShortObjectInspector insp) {
            this.shortInspector = insp;
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                short num = this.shortInspector.get(obj);
                gen.writeNumber((int)num);
            }
        }
    }

    private class LongInspectorHandle
    implements InspectorHandle {
        private LongObjectInspector longInspector;

        public LongInspectorHandle(LongObjectInspector insp) {
            this.longInspector = insp;
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                long num = this.longInspector.get(obj);
                gen.writeNumber(num);
            }
        }
    }

    private class DoubleInspectorHandle
    implements InspectorHandle {
        private DoubleObjectInspector dblInspector;

        public DoubleInspectorHandle(DoubleObjectInspector insp) {
            this.dblInspector = insp;
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                double num = this.dblInspector.get(obj);
                gen.writeNumber(num);
            }
        }
    }

    private class IntInspectorHandle
    implements InspectorHandle {
        private IntObjectInspector intInspector;

        public IntInspectorHandle(IntObjectInspector insp) {
            this.intInspector = insp;
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                int num = this.intInspector.get(obj);
                gen.writeNumber(num);
            }
        }
    }

    private class StringInspectorHandle
    implements InspectorHandle {
        private StringObjectInspector strInspector;

        public StringInspectorHandle(StringObjectInspector insp) {
            this.strInspector = insp;
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                String str = this.strInspector.getPrimitiveJavaObject(obj);
                gen.writeString(str);
            }
        }
    }

    private class ArrayInspectorHandle
    implements InspectorHandle {
        private ListObjectInspector arrayInspector;
        private InspectorHandle valueInspector;

        public ArrayInspectorHandle(ListObjectInspector lInsp) throws UDFArgumentException {
            this.arrayInspector = lInsp;
            this.valueInspector = ToJsonUDF.this.GenerateInspectorHandle(this.arrayInspector.getListElementObjectInspector());
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                gen.writeStartArray();
                List list = this.arrayInspector.getList(obj);
                for (Object listObj : list) {
                    this.valueInspector.generateJson(gen, listObj);
                }
                gen.writeEndArray();
            }
        }
    }

    private class StructInspectorHandle
    implements InspectorHandle {
        private StructObjectInspector structInspector;
        private List<String> fieldNames;
        private List<InspectorHandle> fieldInspectorHandles;

        public StructInspectorHandle(StructObjectInspector insp) throws UDFArgumentException {
            this.structInspector = insp;
            List fieldList = insp.getAllStructFieldRefs();
            this.fieldNames = new ArrayList<String>();
            this.fieldInspectorHandles = new ArrayList<InspectorHandle>();
            for (StructField sf : fieldList) {
                this.fieldNames.add(sf.getFieldName());
                this.fieldInspectorHandles.add(ToJsonUDF.this.GenerateInspectorHandle(sf.getFieldObjectInspector()));
            }
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                gen.writeStartObject();
                List structObjs = this.structInspector.getStructFieldsDataAsList(obj);
                for (int i = 0; i < this.fieldNames.size(); ++i) {
                    String fieldName = this.fieldNames.get(i);
                    if (ToJsonUDF.this.convertFlag.booleanValue()) {
                        gen.writeFieldName(FromJsonUDF.ToCamelCase(fieldName));
                    } else {
                        gen.writeFieldName(fieldName);
                    }
                    this.fieldInspectorHandles.get(i).generateJson(gen, structObjs.get(i));
                }
                gen.writeEndObject();
            }
        }
    }

    private class MapInspectorHandle
    implements InspectorHandle {
        private MapObjectInspector mapInspector;
        private StringObjectInspector keyObjectInspector;
        private InspectorHandle valueInspector;

        public MapInspectorHandle(MapObjectInspector mInsp) throws UDFArgumentException {
            this.mapInspector = mInsp;
            try {
                this.keyObjectInspector = (StringObjectInspector)mInsp.getMapKeyObjectInspector();
            }
            catch (ClassCastException castExc) {
                throw new UDFArgumentException("Only Maps with strings as keys can be converted to valid JSON");
            }
            this.valueInspector = ToJsonUDF.this.GenerateInspectorHandle(mInsp.getMapValueObjectInspector());
        }

        @Override
        public void generateJson(JsonGenerator gen, Object obj) throws JsonGenerationException, IOException {
            if (obj == null) {
                gen.writeNull();
            } else {
                gen.writeStartObject();
                Map map = this.mapInspector.getMap(obj);
                for (Map.Entry entry : map.entrySet()) {
                    String keyJson = this.keyObjectInspector.getPrimitiveJavaObject(entry.getKey());
                    if (ToJsonUDF.this.convertFlag.booleanValue()) {
                        gen.writeFieldName(FromJsonUDF.ToCamelCase(keyJson));
                    } else {
                        gen.writeFieldName(keyJson);
                    }
                    this.valueInspector.generateJson(gen, entry.getValue());
                }
                gen.writeEndObject();
            }
        }
    }

    private static interface InspectorHandle {
        public void generateJson(JsonGenerator var1, Object var2) throws JsonGenerationException, IOException;
    }
}

