/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.sketch;

import brickhouse.analytics.uniques.SketchSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;

@Description(name="combine_previous_sketch", value="_FUNC_(grouping, map) - Returns a map of the combined keys of previous calls to this ")
public class CombinePreviousSketchUDF
extends GenericUDF {
    private StringObjectInspector groupInspector;
    private ListObjectInspector listInspector;
    private MapObjectInspector mapInspector;
    private String lastGrouping = null;
    private SketchSet prevValue = new SketchSet();

    public List evaluate(List<String> l1, List<String> l2) {
        ArrayList<String> newList = new ArrayList<String>();
        if (l1 != null && l1.size() > 0) {
            newList.addAll(l1);
        }
        if (l2 != null && l2.size() > 0) {
            newList.addAll(l2);
        }
        return newList;
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        String grouping = this.groupInspector.getPrimitiveJavaObject(args[0].get());
        if (this.lastGrouping == null || !this.lastGrouping.equals(grouping)) {
            this.lastGrouping = grouping;
            this.prevValue = new SketchSet();
        }
        List<String> prevHashItems = this.prevValue.getMinHashItems();
        List newList = this.listInspector.getList(args[1].get());
        if (newList != null) {
            for (Object strObj : newList) {
                String str = ((StringObjectInspector)this.listInspector.getListElementObjectInspector()).getPrimitiveJavaObject(strObj);
                this.prevValue.addItem(str);
            }
        }
        return prevHashItems;
    }

    public String getDisplayString(String[] args) {
        StringBuilder sb = new StringBuilder("combine_previous_sketch( ");
        for (int i = 0; i < args.length - 1; ++i) {
            sb.append(args[i]);
            sb.append(",");
        }
        sb.append(args[args.length - 1]);
        sb.append(")");
        return sb.toString();
    }

    public ObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length != 2) {
            throw new UDFArgumentException("Usage: combine_previous_sketch takes a grouping string, and a sketch_set");
        }
        ObjectInspector first = args[0];
        if (first.getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)first).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new UDFArgumentException("Usage: combine_previous_sketch takes a grouping string, and a sketch_set");
        }
        this.groupInspector = (StringObjectInspector)first;
        ObjectInspector second = args[1];
        ObjectInspector.Category category = second.getCategory();
        if (category != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException(" combine_previous_sketch only takes sketch_sets.");
        }
        this.listInspector = (ListObjectInspector)second;
        StandardListObjectInspector sketchListInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        return sketchListInspector;
    }
}

