/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.sketch;

import brickhouse.analytics.uniques.SketchSet;
import brickhouse.udf.sketch.SketchSetUDAF;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;

@Description(name="combine_sketch", value="_FUNC_(x) - Combine two sketch sets. ")
public class CombineSketchUDF
extends GenericUDF {
    private ListObjectInspector[] listInspectors;
    private PrimitiveObjectInspector.PrimitiveCategory elemCategory;
    private int sketchSetSize = SketchSetUDAF.DEFAULT_SKETCH_SET_SIZE;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        SketchSet ss = new SketchSet(this.sketchSetSize);
        for (int i = 0; i < arg0.length; ++i) {
            Object listObj = arg0[i].get();
            int listLen = this.listInspectors[i].getListLength(listObj);
            block9: for (int j = 0; j < listLen; ++j) {
                Object uninspObj = this.listInspectors[i].getListElement(listObj, j);
                switch (this.elemCategory) {
                    case STRING: {
                        StringObjectInspector strInspector = (StringObjectInspector)this.listInspectors[i].getListElementObjectInspector();
                        String item = strInspector.getPrimitiveJavaObject(uninspObj);
                        ss.addItem(item);
                        continue block9;
                    }
                    case LONG: {
                        LongObjectInspector bigintInspector = (LongObjectInspector)this.listInspectors[i].getListElementObjectInspector();
                        long itemHash = bigintInspector.get(uninspObj);
                        ss.addHash(itemHash);
                    }
                }
            }
        }
        switch (this.elemCategory) {
            case STRING: {
                return ss.getMinHashItems();
            }
            case LONG: {
                return ss.getMinHashes();
            }
        }
        throw new HiveException("Unexpected Element Category " + this.elemCategory);
    }

    public String getDisplayString(String[] arg0) {
        return "combine_sketch";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length < 2) {
            throw new UDFArgumentException("combine_sketch takes at least two arguments; a set of array<string> or a set of array<bigint>");
        }
        if (arg0[0].getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("combine_sketch takes at least two arguments; a set of array<string> or a set of array<bigint>");
        }
        ObjectInspector lastInspector = arg0[arg0.length - 1];
        int listLen = arg0.length;
        if (lastInspector.getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveObjectInspector)lastInspector).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.INT && !(lastInspector instanceof ConstantObjectInspector)) {
            throw new UDFArgumentException(" Sketch set size must an integer");
        }
        this.listInspectors = new ListObjectInspector[arg0.length];
        this.listInspectors[0] = (ListObjectInspector)arg0[0];
        if (this.listInspectors[0].getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("combine_sketch takes at least two arguments; a set of array<string> or a set of array<bigint>");
        }
        this.elemCategory = ((PrimitiveObjectInspector)this.listInspectors[0].getListElementObjectInspector()).getPrimitiveCategory();
        if (this.elemCategory != PrimitiveObjectInspector.PrimitiveCategory.STRING && this.elemCategory != PrimitiveObjectInspector.PrimitiveCategory.LONG) {
            throw new UDFArgumentException("combine_sketch takes at least two arguments; a set of array<string> or a set of array<bigint>");
        }
        for (int i = 1; i < arg0.length; ++i) {
            if (arg0[i].getCategory() != ObjectInspector.Category.LIST) {
                throw new UDFArgumentException("combine_sketch takes at least two arguments; a set of array<string> or a set of array<bigint>");
            }
            this.listInspectors[i] = (ListObjectInspector)arg0[i];
            if (((PrimitiveObjectInspector)this.listInspectors[0].getListElementObjectInspector()).getPrimitiveCategory() == this.elemCategory) continue;
            throw new UDFArgumentException("combine_sketch takes at least two arguments; a set of array<string> or a set of array<bigint>");
        }
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)this.elemCategory));
    }
}

