/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.sketch;

import brickhouse.analytics.uniques.SketchSet;
import brickhouse.udf.sketch.SketchSetUDAF;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.log4j.Logger;

@Description(name="convert_to_sketch", value="_FUNC_(x) - Truncate a large array of strings, and return a list of strings representing a sketch of those items ")
public class ConvertToSketchUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(ConvertToSketchUDF.class);
    private ListObjectInspector listInspector;
    private StringObjectInspector listElemInspector;
    private StandardListObjectInspector retInspector;
    private int sketchSetSize = SketchSetUDAF.DEFAULT_SKETCH_SET_SIZE;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        Object obj = arg0[0].get();
        if (obj == null) {
            return null;
        }
        List oldList = this.listInspector.getList(obj);
        SketchSet sketchSet = new SketchSet(this.sketchSetSize);
        for (Object oldObj : oldList) {
            if (oldObj == null) {
                LOG.warn((Object)" Object in uninspected List is null");
                continue;
            }
            String newStr = this.listElemInspector.getPrimitiveJavaObject(oldObj);
            sketchSet.addItem(newStr);
        }
        return sketchSet.getMinHashItems();
    }

    public String getDisplayString(String[] arg0) {
        return "convert_to_sketch(" + arg0[0] + ")";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length > 2) {
            throw new UDFArgumentException("convert_to_sketch takes an array of strings, and an optional sketch set size.");
        }
        if (arg0[0].getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("convert_to_sketch takes an array of strings, and an optional sketch set size.");
        }
        this.listInspector = (ListObjectInspector)arg0[0];
        if (this.listInspector.getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)this.listInspector.getListElementObjectInspector()).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new UDFArgumentException("convert_to_sketch takes an array of strings, and an optional sketch set size.");
        }
        this.listElemInspector = (StringObjectInspector)this.listInspector.getListElementObjectInspector();
        if (arg0.length > 1) {
            if (!(arg0[1] instanceof IntObjectInspector) || !(arg0[1] instanceof ConstantObjectInspector)) {
                throw new UDFArgumentException("sketch set size must be a constant int value.");
            }
            IntWritable sizeInt = (IntWritable)((ConstantObjectInspector)arg0[1]).getWritableConstantValue();
            this.sketchSetSize = sizeInt.get();
        }
        this.retInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        return this.retInspector;
    }
}

