/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.sketch;

import brickhouse.analytics.uniques.SketchSet;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.log4j.Logger;

@Description(name="estimated_reach", value="_FUNC_(x) - Estimate reach from a  sketch set of Strings. ")
public class EstimatedReachUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(EstimatedReachUDF.class);
    private ListObjectInspector listInspector;
    private PrimitiveObjectInspector elemInspector;
    private PrimitiveObjectInspector.PrimitiveCategory elemCategory;
    private IntObjectInspector lengthInspector;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        int listLen;
        Object listObj = arg0[0].get();
        int maxItems = SketchSet.DEFAULT_MAX_ITEMS;
        if (arg0.length > 1) {
            maxItems = this.lengthInspector.get(arg0[1].get());
        }
        if ((listLen = this.listInspector.getListLength(listObj)) < maxItems) {
            return (long)listLen;
        }
        if (listLen > maxItems) {
            LOG.warn((Object)("estimated_reach: List length " + listLen + " is greater than sketch set Max items " + maxItems));
        }
        Object uninspMax = this.listInspector.getListElement(listObj, maxItems - 1);
        switch (this.elemCategory) {
            case STRING: {
                StringObjectInspector strInspector = (StringObjectInspector)this.elemInspector;
                String lastItem = strInspector.getPrimitiveJavaObject(uninspMax);
                double reach = SketchSet.EstimatedReach(lastItem, maxItems);
                if (reach > (double)listLen) {
                    return (long)reach;
                }
                return (long)listLen;
            }
            case LONG: {
                LongObjectInspector longInspector = (LongObjectInspector)this.elemInspector;
                long lastHash = longInspector.get(uninspMax);
                double reachHash = SketchSet.EstimatedReach(lastHash, maxItems);
                if (reachHash > (double)listLen) {
                    return (long)reachHash;
                }
                return (long)listLen;
            }
        }
        throw new HiveException("Unexpected category type");
    }

    public String getDisplayString(String[] arg0) {
        StringBuilder sb = new StringBuilder("estimated_reach( ");
        for (int i = 0; i < arg0.length - 1; ++i) {
            sb.append(arg0[i]);
            sb.append(" , ");
        }
        sb.append(arg0[arg0.length - 1]);
        sb.append(" )");
        return sb.toString();
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length != 1 && arg0.length != 2) {
            throw new UDFArgumentException("estimated_reach takes an array of strings or an array of hashes, and an optional sketch size");
        }
        if (arg0[0].getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("estimated_reach takes an array of strings or an array of hashes, and an optional sketch size");
        }
        this.listInspector = (ListObjectInspector)arg0[0];
        if (this.listInspector.getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("estimated_reach takes an array of strings or an array of hashes, and an optional sketch size");
        }
        this.elemInspector = (PrimitiveObjectInspector)this.listInspector.getListElementObjectInspector();
        LOG.info((Object)(" Element category is " + this.elemInspector.getCategory()));
        this.elemCategory = this.elemInspector.getPrimitiveCategory();
        if (this.elemCategory != PrimitiveObjectInspector.PrimitiveCategory.STRING && this.elemCategory != PrimitiveObjectInspector.PrimitiveCategory.LONG) {
            throw new UDFArgumentException("estimated_reach takes an array of strings or an array of hashes, and an optional sketch size");
        }
        if (arg0.length > 1) {
            if (!(arg0[1] instanceof IntObjectInspector)) {
                throw new UDFArgumentException("estimated_reach takes an array of strings or an array of hashes, and an optional sketch size");
            }
            this.lengthInspector = (IntObjectInspector)arg0[1];
        }
        return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
    }
}

