/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.sketch;

import brickhouse.analytics.uniques.SketchSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Description(name="multiday_sketch", value="_FUNC_(x) - Returns a count of events over several different periods,")
public class MultiDaySketcherUDAF
extends AbstractGenericUDAFResolver {
    private static final Logger LOG = Logger.getLogger(MultiDaySketcherUDAF.class);
    private static final String SKETCH_FLAG_PROP = "klout.warehouse.multiday_sketch";

    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        for (int i = 0; i < parameters.length; ++i) {
            LOG.info((Object)("Type " + i + " == " + parameters[i].getTypeName() + " category " + parameters[i].getCategory().name()));
        }
        if (parameters.length != 5 && parameters.length != 6) {
            throw new UDFArgumentTypeException(parameters.length - 1, "multiday_sketch takes date, count, array, date, array ");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(parameters.length - 1, "multiday_sketch takes date, count, array, date, array ");
        }
        MultiDayAggUDAFEvaluator mdEval = new MultiDayAggUDAFEvaluator();
        return mdEval;
    }

    public static class MultiDayAggUDAFEvaluator
    extends GenericUDAFEvaluator {
        private static DateTimeFormatter yyyymmdd = DateTimeFormat.forPattern((String)"yyyyMMdd");
        private Integer[] daysArr;
        private DateTime asofDate;
        private StandardListObjectInspector internalMergeOI;
        private StringObjectInspector asofInspector;
        private StringObjectInspector dtInspector;
        private LongObjectInspector longInspector;
        private ListObjectInspector uniqInspector;
        private ListObjectInspector daysArrInspector;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            LOG.info((Object)(" MODE = " + m.name() + " Num parameters = " + parameters.length));
            for (int i = 0; i < parameters.length; ++i) {
                LOG.info((Object)(" Parameter [ " + i + " ] == " + parameters[i]));
            }
            if (m.equals((Object)GenericUDAFEvaluator.Mode.PARTIAL1) || m.equals((Object)GenericUDAFEvaluator.Mode.COMPLETE)) {
                ObjectInspector firstParam = parameters[0];
                if (firstParam instanceof StringObjectInspector) {
                    this.dtInspector = (StringObjectInspector)parameters[0];
                    this.longInspector = (LongObjectInspector)parameters[1];
                    this.uniqInspector = (ListObjectInspector)parameters[2];
                    this.asofInspector = (StringObjectInspector)parameters[3];
                    this.daysArrInspector = (ListObjectInspector)parameters[4];
                }
                StandardListObjectInspector strListInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
                StandardListObjectInspector listInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)strListInspector);
                return listInspector;
            }
            this.internalMergeOI = (StandardListObjectInspector)parameters[0];
            ArrayList<String> fieldNames = new ArrayList<String>();
            ArrayList<Object> fieldInspectors = new ArrayList<Object>();
            fieldNames.add("num_days");
            fieldInspectors.add(PrimitiveObjectInspectorFactory.javaIntObjectInspector);
            fieldNames.add("cnt");
            fieldInspectors.add(PrimitiveObjectInspectorFactory.javaLongObjectInspector);
            fieldNames.add("sketch_sets");
            fieldInspectors.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector));
            StandardStructObjectInspector structType = ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldInspectors);
            StandardListObjectInspector retType = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)structType);
            return retType;
        }

        private void addMultiDay(MultiDaySketchBuffer mdCounter, DateTime dt, Long cnt, List<Object> uniqs) {
            for (int i = 0; i < this.daysArr.length; ++i) {
                int daysBetween = Days.daysBetween((ReadableInstant)dt, (ReadableInstant)this.asofDate).getDays();
                if (daysBetween >= this.daysArr[i]) continue;
                int n = i;
                mdCounter.counts[n] = mdCounter.counts[n] + cnt;
                for (Object unObj : uniqs) {
                    String uniqStr = ((StringObjectInspector)this.uniqInspector.getListElementObjectInspector()).getPrimitiveJavaObject(unObj);
                    mdCounter.sketches[i].addItem(uniqStr);
                }
            }
        }

        private void setDaysArr(Object obj) {
            List inspected = this.daysArrInspector.getList(obj);
            this.daysArr = new Integer[inspected.size()];
            int idx = 0;
            for (Object elem : inspected) {
                this.daysArr[idx++] = (Integer)((IntObjectInspector)this.daysArrInspector.getListElementObjectInspector()).getPrimitiveJavaObject(elem);
            }
        }

        private void setAsofDate(Object obj) {
            String str = this.asofInspector.getPrimitiveJavaObject(obj);
            this.asofDate = this.getDateTime(str);
        }

        private DateTime getDateTime(String str) {
            DateTime dt = yyyymmdd.parseDateTime(str);
            return dt;
        }

        private long getLong(Object obj) {
            return this.longInspector.get(obj);
        }

        private List getList(Object obj) {
            return this.uniqInspector.getList(obj);
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            MultiDaySketchBuffer buff = new MultiDaySketchBuffer();
            this.reset(buff);
            return buff;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            if (this.daysArr == null) {
                this.setDaysArr(parameters[4]);
                this.reset(agg);
            }
            if (this.asofDate == null) {
                this.setAsofDate(parameters[3]);
            }
            MultiDaySketchBuffer myagg = (MultiDaySketchBuffer)agg;
            DateTime dt = this.getDateTime(this.dtInspector.getPrimitiveJavaObject(parameters[0]));
            long cnt = this.getLong(parameters[1]);
            List uniqList = this.getList(parameters[2]);
            this.addMultiDay(myagg, dt, cnt, uniqList);
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            List partialResultList = this.internalMergeOI.getList(partial);
            if (this.daysArr == null) {
                this.daysArr = new Integer[partialResultList.size()];
            }
            MultiDaySketchBuffer myagg = (MultiDaySketchBuffer)agg;
            if (myagg.counts == null) {
                this.reset(myagg);
            }
            ListObjectInspector subListInspector = (ListObjectInspector)this.internalMergeOI.getListElementObjectInspector();
            StringObjectInspector strInspector = (StringObjectInspector)subListInspector.getListElementObjectInspector();
            int idx = 0;
            for (Object strListObj : partialResultList) {
                List strList = subListInspector.getList(strListObj);
                String numDaysStr = strInspector.getPrimitiveJavaObject(strList.get(0));
                this.daysArr[idx] = Integer.decode(numDaysStr);
                String cntStr = strInspector.getPrimitiveJavaObject(strList.get(1));
                Long cnt = Long.decode(cntStr);
                int n = idx;
                myagg.counts[n] = myagg.counts[n] + cnt;
                for (int j = 2; j < strList.size(); ++j) {
                    String uniqStr = strInspector.getPrimitiveJavaObject(strList.get(j));
                    myagg.sketches[idx].addItem(uniqStr);
                }
                ++idx;
            }
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            MultiDaySketchBuffer countBuff = (MultiDaySketchBuffer)buff;
            if (this.daysArr != null) {
                countBuff.counts = new long[this.daysArr.length];
                countBuff.sketches = new SketchSet[this.daysArr.length];
                for (int i = 0; i < countBuff.sketches.length; ++i) {
                    countBuff.sketches[i] = new SketchSet();
                }
            }
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MultiDaySketchBuffer myagg = (MultiDaySketchBuffer)agg;
            ArrayList ret = new ArrayList();
            for (int i = 0; i < this.daysArr.length; ++i) {
                ArrayList<Object> structArr = new ArrayList<Object>();
                structArr.add(this.daysArr[i]);
                structArr.add(myagg.counts[i]);
                List<String> sketchList = myagg.sketches[i].getMinHashItems();
                structArr.add(sketchList);
                ret.add(structArr);
            }
            return ret;
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MultiDaySketchBuffer myagg = (MultiDaySketchBuffer)agg;
            ArrayList ret = new ArrayList();
            for (int i = 0; i < this.daysArr.length; ++i) {
                ArrayList<String> strList = new ArrayList<String>();
                strList.add(Integer.toString(this.daysArr[i]));
                strList.add(Long.toString(myagg.counts[i]));
                List<String> itemList = myagg.sketches[i].getMinHashItems();
                for (String minHashItem : itemList) {
                    strList.add(minHashItem);
                }
                ret.add(strList);
            }
            return ret;
        }

        static class MultiDaySketchBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            long[] counts;
            SketchSet[] sketches;

            MultiDaySketchBuffer() {
            }
        }
    }
}

