/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.sketch;

import brickhouse.analytics.uniques.SketchSet;
import brickhouse.udf.sketch.SketchSetUDAF;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

class SketchSetBuffer
implements GenericUDAFEvaluator.AggregationBuffer {
    private SketchSet sketchSet = null;

    SketchSetBuffer() {
    }

    public void init(int size) {
        if (this.sketchSet == null || this.sketchSet.getMaxItems() != size && size != -1) {
            this.sketchSet = new SketchSet(size);
        } else {
            this.sketchSet.clear();
        }
    }

    public void reset() {
        this.sketchSet.clear();
    }

    public int getSize() {
        if (this.sketchSet != null) {
            return this.sketchSet.getMaxItems();
        }
        return -1;
    }

    public List<String> getSketchItems() {
        return this.sketchSet.getMinHashItems();
    }

    public Map<Long, String> getPartialMap() {
        SortedMap<Long, String> partial = this.sketchSet.getHashItemMap();
        partial.put(Long.valueOf(this.sketchSet.getMaxItems()), SketchSetUDAF.SKETCH_SIZE_STR);
        return partial;
    }

    public void addItem(String str) {
        this.sketchSet.addItem(str);
    }

    public void addHash(Long hash, String str) {
        this.sketchSet.addHashItem(hash, str);
    }
}

