/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.sketch;

import brickhouse.udf.sketch.SketchSetBuffer;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.IntWritable;
import org.apache.log4j.Logger;

@Description(name="sketch_set", value="_FUNC_(x) - Constructs a sketch set to estimate reach for large values  ")
public class SketchSetUDAF
extends AbstractGenericUDAFResolver {
    private static final Logger LOG = Logger.getLogger(SketchSetUDAF.class);
    public static int DEFAULT_SKETCH_SET_SIZE = 5000;
    static String SKETCH_SIZE_STR = "SKETCH_SIZE";

    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (!parameters[0].getTypeName().equals("string") && !parameters[0].getTypeName().equals("bigint")) {
            throw new SemanticException("sketch_set UDAF only takes String or longs as values; not " + parameters[0].getTypeName());
        }
        if (parameters.length > 1 && !parameters[1].getTypeName().equals("int")) {
            throw new SemanticException("Size of sketch must be an int; Got " + parameters[1].getTypeName());
        }
        return new SketchSetUDAFEvaluator();
    }

    public static class SketchSetUDAFEvaluator
    extends GenericUDAFEvaluator {
        private StringObjectInspector inputStrOI;
        private MapObjectInspector partialMapOI;
        private LongObjectInspector partialMapHashOI;
        private StringObjectInspector partialMapStrOI;
        private int sketchSetSize = -1;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputStrOI = (StringObjectInspector)parameters[0];
                if (parameters.length > 1 && m == GenericUDAFEvaluator.Mode.PARTIAL1) {
                    if (!(parameters[1] instanceof ConstantObjectInspector)) {
                        throw new HiveException("Sketch Set size must be a constant");
                    }
                    ConstantObjectInspector sizeOI = (ConstantObjectInspector)parameters[1];
                    this.sketchSetSize = ((IntWritable)sizeOI.getWritableConstantValue()).get();
                } else {
                    this.sketchSetSize = DEFAULT_SKETCH_SET_SIZE;
                }
            } else {
                this.partialMapOI = (MapObjectInspector)parameters[0];
                this.partialMapHashOI = (LongObjectInspector)this.partialMapOI.getMapKeyObjectInspector();
                this.partialMapStrOI = (StringObjectInspector)this.partialMapOI.getMapValueObjectInspector();
            }
            if (m == GenericUDAFEvaluator.Mode.FINAL || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
            }
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            SketchSetBuffer buff = new SketchSetBuffer();
            buff.init(this.sketchSetSize);
            return buff;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object strObj = parameters[0];
            if (strObj != null) {
                String str = this.inputStrOI.getPrimitiveJavaObject(strObj);
                SketchSetBuffer myagg = (SketchSetBuffer)agg;
                myagg.addItem(str);
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            Map partialResult;
            SketchSetBuffer myagg = (SketchSetBuffer)agg;
            if (partial != null && (partialResult = this.partialMapOI.getMap(partial)) != null) {
                String item;
                Long hash;
                if (myagg.getSize() == -1) {
                    for (Map.Entry entry : partialResult.entrySet()) {
                        hash = this.partialMapHashOI.get(entry.getKey());
                        item = this.partialMapStrOI.getPrimitiveJavaObject(entry.getValue());
                        if (!item.equals(SKETCH_SIZE_STR)) continue;
                        this.sketchSetSize = hash.intValue();
                        myagg.init(this.sketchSetSize);
                        break;
                    }
                }
                for (Map.Entry entry : partialResult.entrySet()) {
                    hash = this.partialMapHashOI.get(entry.getKey());
                    item = this.partialMapStrOI.getPrimitiveJavaObject(entry.getValue());
                    if (item.equals(SKETCH_SIZE_STR)) continue;
                    myagg.addHash(hash, item);
                }
            }
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            SketchSetBuffer sketchBuff = (SketchSetBuffer)buff;
            sketchBuff.reset();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SketchSetBuffer myagg = (SketchSetBuffer)agg;
            return myagg.getSketchItems();
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SketchSetBuffer myagg = (SketchSetBuffer)agg;
            return myagg.getPartialMap();
        }
    }
}

