/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.timeseries;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.log4j.Logger;

@Description(name="moving_avg", value=" return the moving average of a time series for a given timewindow")
public class MovingAvgUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(MovingAvgUDF.class);
    private ListObjectInspector listInspector;
    private IntObjectInspector dayWindowInspector;

    private List<Double> parseDoubleList(List<Object> objList) {
        ArrayList<Double> arrList = new ArrayList<Double>();
        for (Object obj : objList) {
            Object dblObj = ((PrimitiveObjectInspector)this.listInspector.getListElementObjectInspector()).getPrimitiveJavaObject(obj);
            if (dblObj instanceof Number) {
                Number dblNum = (Number)dblObj;
                arrList.add(dblNum.doubleValue());
                continue;
            }
            String dblStr = dblObj.toString();
            try {
                Double dblCoerce = Double.parseDouble(dblStr);
                arrList.add(dblCoerce);
            }
            catch (NumberFormatException formatExc) {
                LOG.info((Object)(" Unable to interpret " + dblStr + " as a number"));
            }
        }
        return arrList;
    }

    public List<Double> evaluate(List<Object> timeSeriesObj, int dayWindow) {
        List<Double> timeSeries = this.parseDoubleList(timeSeriesObj);
        ArrayList<Double> mvnAvgTimeSeries = new ArrayList<Double>(timeSeries.size());
        double mvnTotal = 0.0;
        for (int i = 0; i < timeSeries.size(); ++i) {
            double mvnAvg;
            mvnTotal += timeSeries.get(i).doubleValue();
            if (i >= dayWindow) {
                mvnAvg = (mvnTotal -= timeSeries.get(i - dayWindow).doubleValue()) / (double)dayWindow;
                mvnAvgTimeSeries.add(mvnAvg);
                continue;
            }
            if (i > 0) {
                mvnAvg = mvnTotal / ((double)i + 1.0);
                mvnAvgTimeSeries.add(mvnAvg);
                continue;
            }
            mvnAvgTimeSeries.add(mvnTotal);
        }
        return mvnAvgTimeSeries;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        List argList = this.listInspector.getList(arg0[0].get());
        int dayWindow = this.dayWindowInspector.get(arg0[1].get());
        if (argList != null) {
            return this.evaluate(argList, dayWindow);
        }
        return null;
    }

    public String getDisplayString(String[] arg0) {
        return "moving_avg(" + arg0[0] + ")";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        this.listInspector = (ListObjectInspector)arg0[0];
        this.dayWindowInspector = (IntObjectInspector)arg0[1];
        LOG.info((Object)("Moving Average Object input type is " + this.listInspector + " element = " + this.listInspector.getListElementObjectInspector()));
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector);
    }
}

